/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.util;

import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FontSizeUtil {
    public static void refitFontSize(Font font, JLabel label) {
        FontSizeUtil.refitFontSize(font, label, label.getText());
    }

    public static void refitFontSize(Font font, JLabel label, String labelText) {
        int fontSizeToUse;
        FontMetrics fontMetrics = label.getFontMetrics(font);
        int stringWidth = fontMetrics.stringWidth(labelText);
        if (stringWidth <= 0) {
            return;
        }
        int stringHeight = fontMetrics.getHeight();
        if (stringHeight <= 0) {
            return;
        }
        int componentWidth = (int)Math.floor((float)label.getWidth() * 0.9f);
        int componentHeight = label.getHeight();
        float widthRatio = (float)componentWidth / (float)stringWidth;
        float heightRatio = (float)componentHeight / (float)stringHeight;
        int fontSizeW = (int)Math.floor((float)font.getSize() * widthRatio);
        int fontSizeH = (int)Math.floor((float)font.getSize() * heightRatio);
        for (fontSizeToUse = Math.min(fontSizeW, fontSizeH); fontSizeToUse > 1 && !FontSizeUtil.doesTextFit(labelText, fontMetrics, componentWidth, componentHeight); --fontSizeToUse) {
        }
        if (fontSizeToUse > 0) {
            label.setFont(new Font(font.getName(), font.getStyle(), fontSizeToUse));
        } else {
            label.setFont(font);
        }
    }

    public static void refitFontSize(Font font, JTextField textField) {
        int fontSizeToUse;
        String labelText = textField.getText();
        FontMetrics fontMetrics = textField.getFontMetrics(font);
        int stringWidth = fontMetrics.stringWidth(labelText);
        if (stringWidth <= 0) {
            return;
        }
        int stringHeight = fontMetrics.getHeight();
        if (stringHeight <= 0) {
            return;
        }
        int componentWidth = (int)Math.floor((float)(textField.getWidth() - 4) * 0.9f);
        int componentHeight = textField.getHeight() - 4;
        float widthRatio = (float)componentWidth / (float)stringWidth;
        float heightRatio = (float)componentHeight / (float)stringHeight;
        int fontSizeW = (int)Math.floor((float)font.getSize() * widthRatio);
        int fontSizeH = (int)Math.floor((float)font.getSize() * heightRatio);
        for (fontSizeToUse = Math.min(fontSizeW, fontSizeH); fontSizeToUse > 1 && !FontSizeUtil.doesTextFit(labelText, fontMetrics, componentWidth, componentHeight); --fontSizeToUse) {
        }
        if (fontSizeToUse > 0) {
            textField.setFont(new Font(font.getName(), font.getStyle(), fontSizeToUse));
        } else {
            textField.setFont(font);
        }
    }

    private static boolean doesTextFit(String text, FontMetrics fontMetrics, int componentWidth, int componentHeight) {
        int stringWidth = fontMetrics.stringWidth(text);
        int stringHeight = fontMetrics.getHeight();
        return stringWidth < componentWidth && stringHeight < componentHeight;
    }
}

