/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.NewazaPoints;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.TextSource;
import si.nevensrok.jtekma.tabla.gui.horizontal.ChallengePanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.NewazaPointBox;
import si.nevensrok.jtekma.tabla.gui.horizontal.PenaltyTracker;

public class NewazaPointsPanel
extends JLabel {
    private JPanel pointsPanel = new JPanel();
    private NewazaPointBox point2Box;
    private NewazaPointBox point3Box;
    private NewazaPointBox point4Box;
    private NewazaPointBox point100Box;
    private NewazaPointBox advantageBox;
    private NewazaPointBox penaltyBox;
    private NewazaPointBox hansokumakeBox;
    private PenaltyTracker penaltyTracker;
    private ChallengePanel challengePanel;

    public NewazaPointsPanel(CompetitorType competitorType) {
        this.point2Box = new NewazaPointBox("P2", competitorType, PointType.POINT2);
        this.point3Box = new NewazaPointBox("P3", competitorType, PointType.POINT3);
        this.point4Box = new NewazaPointBox("P4", competitorType, PointType.POINT4);
        this.point100Box = new NewazaPointBox("P100", competitorType, PointType.POINT100);
        this.advantageBox = new NewazaPointBox("A", competitorType, PointType.ADVANTAGE);
        this.penaltyBox = new NewazaPointBox("PE", competitorType, PointType.PENALTY);
        this.hansokumakeBox = new NewazaPointBox("H", competitorType, PointType.HANSOKUMAKE);
        this.penaltyTracker = new PenaltyTracker(competitorType);
        this.challengePanel = new ChallengePanel(competitorType);
        this.setLayout(null);
        this.pointsPanel.setLayout(new GridLayout(2, 4));
        this.pointsPanel.add(this.point2Box);
        this.pointsPanel.add(this.point3Box);
        this.pointsPanel.add(this.point4Box);
        this.pointsPanel.add(this.point100Box);
        this.pointsPanel.add(this.advantageBox);
        this.pointsPanel.add(this.penaltyBox);
        this.pointsPanel.add(this.hansokumakeBox);
        this.pointsPanel.add(new JLabel());
        this.add(this.pointsPanel);
        this.add(this.penaltyTracker);
        this.add(this.challengePanel);
    }

    public void setNewazaPoints(NewazaPoints newazaPoints) {
        this.point2Box.setNewazaPoints(newazaPoints);
        this.point3Box.setNewazaPoints(newazaPoints);
        this.point4Box.setNewazaPoints(newazaPoints);
        this.point100Box.setNewazaPoints(newazaPoints);
        this.advantageBox.setNewazaPoints(newazaPoints);
        this.penaltyBox.setNewazaPoints(newazaPoints);
        this.hansokumakeBox.setNewazaPoints(newazaPoints);
        this.penaltyTracker.setNewazaPoints(newazaPoints);
    }

    public void setMatchData(MatchData matchData) {
        this.point2Box.setMatchData(matchData);
        this.point3Box.setMatchData(matchData);
        this.point4Box.setMatchData(matchData);
        this.point100Box.setMatchData(matchData);
        this.advantageBox.setMatchData(matchData);
        this.penaltyBox.setMatchData(matchData);
        this.hansokumakeBox.setMatchData(matchData);
        this.penaltyTracker.setMatchData(matchData);
        this.challengePanel.setMatchData(matchData);
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.point2Box.setTablaManager(tablaManager);
        this.point3Box.setTablaManager(tablaManager);
        this.point4Box.setTablaManager(tablaManager);
        this.point100Box.setTablaManager(tablaManager);
        this.advantageBox.setTablaManager(tablaManager);
        this.penaltyBox.setTablaManager(tablaManager);
        this.hansokumakeBox.setTablaManager(tablaManager);
        this.penaltyTracker.setTablaManager(tablaManager);
        this.challengePanel.setTablaManager(tablaManager);
    }

    public void setTextSource(TextSource textSource) {
        this.challengePanel.setTextSource(textSource);
        this.penaltyTracker.setTextSource(textSource);
    }

    public void redrawElements() {
        int width = this.getWidth();
        int height = this.getHeight();
        int pointsPanelHeight = (int)Math.floor((float)height * 0.5f);
        this.pointsPanel.setLocation(0, 0);
        this.pointsPanel.setSize(width, pointsPanelHeight);
        int penaltyTrackerHeight = (int)Math.floor((float)height * 0.25f);
        this.penaltyTracker.setLocation(0, pointsPanelHeight);
        this.penaltyTracker.setSize(width, penaltyTrackerHeight);
        this.challengePanel.setLocation(0, pointsPanelHeight + penaltyTrackerHeight);
        this.challengePanel.setSize(width, height - pointsPanelHeight - penaltyTrackerHeight);
        this.point2Box.redrawElements();
        this.point3Box.redrawElements();
        this.point4Box.redrawElements();
        this.point100Box.redrawElements();
        this.advantageBox.redrawElements();
        this.penaltyBox.redrawElements();
        this.hansokumakeBox.redrawElements();
        this.penaltyTracker.redrawElements();
        this.challengePanel.redrawElements();
        this.repaint();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.pointsPanel != null) {
            this.pointsPanel.setBackground(bg);
        }
        if (this.point2Box != null) {
            this.point2Box.setBackground(bg);
        }
        if (this.point3Box != null) {
            this.point3Box.setBackground(bg);
        }
        if (this.point4Box != null) {
            this.point4Box.setBackground(bg);
        }
        if (this.point100Box != null) {
            this.point100Box.setBackground(bg);
        }
        if (this.advantageBox != null) {
            this.advantageBox.setBackground(bg);
        }
        if (this.penaltyBox != null) {
            this.penaltyBox.setBackground(bg);
        }
        if (this.hansokumakeBox != null) {
            this.hansokumakeBox.setBackground(bg);
        }
        if (this.challengePanel != null) {
            this.challengePanel.setBackground(bg);
        }
        if (this.penaltyTracker != null) {
            this.penaltyTracker.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.pointsPanel != null) {
            this.pointsPanel.setForeground(fg);
        }
        if (this.point2Box != null) {
            this.point2Box.setForeground(fg);
        }
        if (this.point3Box != null) {
            this.point3Box.setForeground(fg);
        }
        if (this.point4Box != null) {
            this.point4Box.setForeground(fg);
        }
        if (this.point100Box != null) {
            this.point100Box.setForeground(fg);
        }
        if (this.advantageBox != null) {
            this.advantageBox.setForeground(fg);
        }
        if (this.penaltyBox != null) {
            this.penaltyBox.setForeground(fg);
        }
        if (this.hansokumakeBox != null) {
            this.hansokumakeBox.setForeground(fg);
        }
        if (this.challengePanel != null) {
            this.challengePanel.setForeground(fg);
        }
        if (this.penaltyTracker != null) {
            this.penaltyTracker.setForeground(fg);
        }
    }
}

