/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import java.awt.EventQueue;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class NamePanel
extends JPanel {
    private JLabel nameLabel = new JLabel();
    private JLabel clubLabel = new JLabel();

    public NamePanel() {
        this.setLayout(null);
        this.add(this.nameLabel);
        this.add(this.clubLabel);
        this.nameLabel.setFont(Constants.FONT);
        this.nameLabel.setHorizontalAlignment(0);
        this.clubLabel.setFont(Constants.FONT);
        this.clubLabel.setHorizontalAlignment(0);
    }

    public void setCompetitorName(final String name) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NamePanel.this.nameLabel.setText(name);
                FontSizeUtil.refitFontSize(Constants.FONT, NamePanel.this.nameLabel);
            }
        });
    }

    public void setCompetitorClub(final String club) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NamePanel.this.clubLabel.setText(club);
                FontSizeUtil.refitFontSize(Constants.FONT, NamePanel.this.clubLabel);
            }
        });
    }

    public void redrawElements() {
        int width = this.getWidth();
        int height = this.getHeight();
        int nameLabelHeight = (int)Math.floor((float)height * 0.65f);
        this.nameLabel.setLocation(0, 0);
        this.nameLabel.setSize(width, nameLabelHeight);
        FontSizeUtil.refitFontSize(Constants.FONT, this.nameLabel);
        this.clubLabel.setLocation(0, nameLabelHeight);
        this.clubLabel.setSize(width, height - nameLabelHeight);
        FontSizeUtil.refitFontSize(Constants.FONT, this.clubLabel);
        this.repaint();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.nameLabel != null) {
            this.nameLabel.setForeground(fg);
        }
        if (this.clubLabel != null) {
            this.clubLabel.setForeground(fg);
        }
    }
}

