$(document).ready(function() {
	$("[rel='tooltip']").tooltip();
	
	$(".chosen-select").each(function(index) {
		var width=$(this).attr("width");
		var options={
			"search_contains":true
		};
		if (width) {
			options.width=width;
		}
		$(this).chosen(options);
	});
	
	$(".color-picker").each(function(index) {
		var field=this;
		var color="#FFFFFF";
		
		if ($(field).prop("tagName")=="INPUT") {
			if ($(field).val()!="") {
				color=$(field).val();
			}
			$(field).ColorPicker({
				"color":color,
				onChange:function(hsb, hex, rgb, el) {
					$(field).val(hex);
				}
			});
		}
		else {
			var rgb=$(field).css("background-color");
			if (rgb!="transparent") {
				rgb=rgb.substring(4,rgb.length-1).replace(/\s/g,"").split(",");
				color="#";
				for (var i=0;i<3;i++) {
					if (Number(rgb[i])<10) {
						color+="0";
					}
					color+=Number(rgb[i]).toString(16);
				}
			}
			$(field).ColorPicker({
				"color":color,
				onChange:function(hsb, hex, rgb, el) {
					$(field).css('backgroundColor', '#' + hex);
				}
			});
		}
	});

	$("input.date").each(function(index) {
		var dateFormat=$(this).attr("date-format");
		if (!dateFormat) {
			dateFormat=defaultDateFormat;
		}
		$(this).datepicker({
			"dateFormat":dateFormat
		});
	});
	
	$("input.datetime").each(function(index) {
		var dateFormat=$(this).attr("date-format");
		var timeFormat=$(this).attr("time-format");
		if (!dateFormat) {
			dateFormat=defaultDateFormat;
		}
		if (!timeFormat) {
			timeFormat=defaultTimeFormat;
		}
		$(this).datetimepicker({
			"dateFormat":dateFormat,
			"timeFormat":timeFormat
		});
	});
	
	$("input.time").each(function(index) {
		var timeFormat=$(this).attr("time-format");
		if (!timeFormat) {
			timeFormat=defaultTimeFormat;
		}
		$(this).timepicker({
			"timeFormat":timeFormat
		});
	});

	$("[slider-for]").each(function(index) {
		var sliderField=this;
		var forInputName=$(sliderField).attr("slider-for");
		var forInput=$(sliderField).parent().find("input[name='"+forInputName+"']");
		var min=Number($(sliderField).attr("min"));
		var max=Number($(sliderField).attr("max"));
		var step=Number($(sliderField).attr("step"));

		if (String(min)=="NaN") {
			min=0;
		}
		if (String(max)=="NaN") {
			max=100;
		}
		if (String(step)=="NaN") {
			step=1;
		}

		$(sliderField).slider({
			"min":min,
			"max":max,
			"step":step,
			"value":$(forInput).val(),
			"change":function(event,ui) {
				forInput.val(ui.value);
			},
			"slide":function(event,ui) {
				forInput.val(ui.value);
			}
		});

		forInput.on("change",function() {
			var value=Number($(this).val());
			if ($(this).val()=="" || String(value)=="NaN") {
				$(this).val("0");
			}
			if (value<min) {
				value=min;
			}
			if (value>max) {
				value=max;
			}
			$(sliderField).slider("value",value);
		});
		forInput.on("keyup",function() {
			var value=Number($(this).val());
			if ($(this).val()!="" && String(value)!="NaN") {
				if (value>=min && value<=max) {
					$(sliderField).slider("value",value);
				}
			}
		});
	});

	$("input.spinner").each(function(index) {
		var min=Number($(this).attr("min"));
		var max=Number($(this).attr("max"));
		var step=Number($(this).attr("step"));
		var numberFormat=$(this).attr("number-format");

		if (String(min)=="NaN") {
			min=0;
		}
		if (String(max)=="NaN") {
			max=100;
		}
		if (String(step)=="NaN") {
			step=1;
		}
		if (!numberFormat) {
			numberFormat="n";
		}

		$(this).spinner({
			"min":min,
			"max":max,
			"step":step,
			"numberFormat":numberFormat
		});
	});
	
});
