/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dl;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.dl.CoreDao;
import si.nevensrok.common.dl.Dto;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.adapters.database.DatabaseAdapterPool;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.ListDataResult;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.StringUtil;

public abstract class ExtendedDao<P, DTO extends Dto<P>, POJO extends Pojo<P>>
extends CoreDao
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedDao.class);
    private static final int databaseLockRetries = 10;
    private static final int databaseLockTimeout = 5;
    private Class<DTO> dtoClass;
    private Class<POJO> pojoClass;
    private DatabaseAdapterPool adapterPool;

    protected abstract String getTableFieldName(String var1);

    public Class<DTO> getDtoClass() {
        return this.dtoClass;
    }

    public Class<POJO> getPojoClass() {
        return this.pojoClass;
    }

    public DatabaseAdapterPool getAdapterPool() {
        return this.adapterPool;
    }

    public ExtendedDao(Class<DTO> dtoClass, Class<POJO> pojoClass) {
        this.dtoClass = dtoClass;
        this.pojoClass = pojoClass;
    }

    public void setDatabaseAdapterPool(DatabaseAdapterPool adapterPool) {
        this.adapterPool = adapterPool;
    }

    private void waitForRetry() {
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.adapterPool == null) {
            throw new IllegalArgumentException("Property 'adapterPool' is requied");
        }
        super.afterPropertiesSet();
    }

    public POJO create(POJO inst) {
        Dto dto = (Dto)this.getAdapterPool().create(this.dtoClass, inst);
        boolean executed = false;
        for (int i = 0; i < 10; ++i) {
            try {
                dto = super.createInstance(dto);
                inst.setId(dto.getId());
                executed = true;
                break;
            }
            catch (LockAcquisitionException e) {
                LOGGER.trace("Database deadlock detected", (Throwable)e);
                this.waitForRetry();
                continue;
            }
        }
        this.flush();
        if (!executed) {
            throw new HibernateException("Error creating instance");
        }
        return inst;
    }

    public List<POJO> createList(List<POJO> instList) {
        for (Pojo inst : instList) {
            Dto dto = (Dto)this.getAdapterPool().create(this.dtoClass, inst);
            dto = super.createInstance(dto);
            inst.setId(dto.getId());
        }
        this.flush();
        return instList;
    }

    public POJO save(POJO inst) {
        Dto dto = (Dto)this.getAdapterPool().create(this.dtoClass, inst);
        boolean executed = false;
        for (int i = 0; i < 10; ++i) {
            try {
                dto = super.saveInstance(dto);
                inst.setId(dto.getId());
                executed = true;
                break;
            }
            catch (LockAcquisitionException e) {
                LOGGER.trace("Database deadlock detected", (Throwable)e);
                this.waitForRetry();
                continue;
            }
        }
        this.flush();
        if (!executed) {
            throw new HibernateException("Error saving instance");
        }
        return inst;
    }

    public List<POJO> saveList(List<POJO> instList) {
        for (Pojo inst : instList) {
            Dto dto = (Dto)this.getAdapterPool().create(this.dtoClass, inst);
            dto = super.saveInstance(dto);
            inst.setId(dto.getId());
        }
        this.flush();
        return instList;
    }

    public POJO update(POJO inst) {
        Dto dto = (Dto)this.getAdapterPool().create(this.dtoClass, inst);
        boolean executed = false;
        for (int i = 0; i < 10; ++i) {
            try {
                super.updateInstance(dto);
                executed = true;
                break;
            }
            catch (LockAcquisitionException e) {
                LOGGER.trace("Database deadlock detected", (Throwable)e);
                this.waitForRetry();
                continue;
            }
        }
        this.flush();
        if (!executed) {
            throw new HibernateException("Error updating instance");
        }
        return inst;
    }

    public List<POJO> updateList(List<POJO> instList) {
        for (Pojo inst : instList) {
            Dto dto = (Dto)this.getAdapterPool().create(this.dtoClass, inst);
            super.updateInstance(dto);
        }
        this.flush();
        return instList;
    }

    public void delete(POJO inst) {
        boolean executed = false;
        for (int i = 0; i < 10; ++i) {
            try {
                Dto dto = (Dto)this.getAdapterPool().create(this.dtoClass, inst);
                super.deleteInstance(dto);
                executed = true;
                break;
            }
            catch (LockAcquisitionException e) {
                LOGGER.trace("Database deadlock detected", (Throwable)e);
                this.waitForRetry();
                continue;
            }
        }
        this.flush();
        if (!executed) {
            throw new HibernateException("Error deleting instance");
        }
    }

    public void deleteList(List<POJO> instList) {
        for (Pojo inst : instList) {
            Dto dto = (Dto)this.getAdapterPool().create(this.dtoClass, inst);
            super.deleteInstance(dto);
        }
        this.flush();
    }

    protected void addSort(StringBuilder sqlQuery, Sort sort) {
        if (sort == null) {
            return;
        }
        boolean first = true;
        for (Sort.Field sortField : sort.getFieldList()) {
            if (first) {
                first = false;
                sqlQuery.append(" order by");
            } else {
                sqlQuery.append(",");
            }
            sqlQuery.append(" ");
            if (!sortField.isCaseSensitive()) {
                sqlQuery.append("UPPER(main.");
                sqlQuery.append(this.getTableFieldName(sortField.getFieldName()));
                sqlQuery.append(")");
            } else {
                sqlQuery.append("main.");
                sqlQuery.append(this.getTableFieldName(sortField.getFieldName()));
            }
            if (sortField.getDirection() != Sort.Field.Direction.DESC) continue;
            sqlQuery.append(" desc");
        }
    }

    protected void addFilter(StringBuilder sqlQuery, ParamsBinder params, Filter filter) throws Exception {
        this.addFilter(sqlQuery, params, filter, true);
    }

    protected void addFilter(StringBuilder sqlQuery, ParamsBinder params, Filter filter, boolean caseSensitive) throws Exception {
        if (filter == null) {
            return;
        }
        if (filter instanceof ExampleFilter) {
            ExampleFilter exampleFilter = (ExampleFilter)filter;
            this.getAdapterPool().applyFilterByExample(this.dtoClass, sqlQuery, params, exampleFilter.getExample(), caseSensitive);
        } else if (filter instanceof FieldFilter) {
            FieldFilter fieldFilter = (FieldFilter)filter;
            sqlQuery.append(" ");
            if (fieldFilter.getComparator() == FieldFilter.Comparator.LIKECASEISENSITIVE || fieldFilter.getComparator() == FieldFilter.Comparator.NOTLIKECASEISENSITIVE || fieldFilter.getComparator() == FieldFilter.Comparator.EQUALCASEISENSITIVE || fieldFilter.getComparator() == FieldFilter.Comparator.NOTEQUALCASEISENSITIVE) {
                sqlQuery.append("UPPER(main.");
                sqlQuery.append(this.getTableFieldName(fieldFilter.getFieldName()));
                sqlQuery.append(")");
            } else {
                sqlQuery.append("main.");
                sqlQuery.append(this.getTableFieldName(fieldFilter.getFieldName()));
            }
            if (fieldFilter.getComparator() == FieldFilter.Comparator.EQUAL || fieldFilter.getComparator() == FieldFilter.Comparator.EQUALCASEISENSITIVE) {
                sqlQuery.append("=");
            } else if (fieldFilter.getComparator() == FieldFilter.Comparator.NOTEQUAL || fieldFilter.getComparator() == FieldFilter.Comparator.NOTEQUALCASEISENSITIVE) {
                sqlQuery.append("!=");
            } else if (fieldFilter.getComparator() == FieldFilter.Comparator.LESS) {
                sqlQuery.append("<");
            } else if (fieldFilter.getComparator() == FieldFilter.Comparator.LESSOREQUAL) {
                sqlQuery.append("<=");
            } else if (fieldFilter.getComparator() == FieldFilter.Comparator.MORE) {
                sqlQuery.append(">");
            } else if (fieldFilter.getComparator() == FieldFilter.Comparator.MOREOREQUAL) {
                sqlQuery.append(">=");
            } else if (fieldFilter.getComparator() == FieldFilter.Comparator.LIKE || fieldFilter.getComparator() == FieldFilter.Comparator.LIKECASEISENSITIVE) {
                sqlQuery.append(" like ");
            } else if (fieldFilter.getComparator() == FieldFilter.Comparator.NOTLIKE || fieldFilter.getComparator() == FieldFilter.Comparator.NOTLIKECASEISENSITIVE) {
                sqlQuery.append(" not like ");
            } else if (fieldFilter.getComparator() == FieldFilter.Comparator.ISNULL) {
                sqlQuery.append(" is null");
            } else if (fieldFilter.getComparator() == FieldFilter.Comparator.ISNOTNULL) {
                sqlQuery.append(" is not null");
            } else if (fieldFilter.getComparator() == FieldFilter.Comparator.IN) {
                sqlQuery.append(" in ");
            } else if (fieldFilter.getComparator() == FieldFilter.Comparator.NOTIN) {
                sqlQuery.append(" not in ");
            }
            if (fieldFilter.getComparator() != FieldFilter.Comparator.ISNULL && fieldFilter.getComparator() != FieldFilter.Comparator.ISNOTNULL) {
                if (fieldFilter.getComparator() == FieldFilter.Comparator.LIKECASEISENSITIVE || fieldFilter.getComparator() == FieldFilter.Comparator.NOTLIKECASEISENSITIVE || fieldFilter.getComparator() == FieldFilter.Comparator.EQUALCASEISENSITIVE || fieldFilter.getComparator() == FieldFilter.Comparator.NOTEQUALCASEISENSITIVE) {
                    sqlQuery.append("UPPER(");
                    sqlQuery.append(params.addParam(fieldFilter.getValue()));
                    sqlQuery.append(")");
                } else {
                    sqlQuery.append(params.addParam(fieldFilter.getValue()));
                }
            }
        } else if (filter instanceof GroupFilter) {
            StringBuilder subQuery = new StringBuilder();
            GroupFilter groupFilter = (GroupFilter)filter;
            boolean first = true;
            for (Filter subFilter : groupFilter.getFilters()) {
                StringBuilder filterQuery = new StringBuilder();
                this.addFilter(filterQuery, params, subFilter, caseSensitive);
                if (filterQuery.length() == 0) continue;
                if (first) {
                    first = false;
                } else if (groupFilter.getCombining() == GroupFilter.Combine.AND) {
                    subQuery.append(" and");
                } else {
                    subQuery.append(" or");
                }
                subQuery.append((CharSequence)filterQuery);
            }
            if (subQuery.length() > 0) {
                sqlQuery.append(" (");
                sqlQuery.append((CharSequence)subQuery);
                sqlQuery.append(")");
            }
        } else {
            LOGGER.warn("Unsupported filter type " + filter.getClass().getName());
        }
    }

    public POJO getById(P id) {
        Dto dto = (Dto)this.getCurrentSession().get(this.dtoClass, (Serializable)id);
        Pojo pojo = null;
        if (dto != null) {
            pojo = (Pojo)this.getAdapterPool().create(this.pojoClass, dto);
        }
        this.flush();
        return (POJO)pojo;
    }

    public PageDataResult<POJO> find(DataFilter dataFilter) {
        return this.find(dataFilter, true);
    }

    public PageDataResult<POJO> find(DataFilter dataFilter, boolean caseSensitive) {
        return this.find(dataFilter, caseSensitive, null, null, null, null);
    }

    public PageDataResult<POJO> find(DataFilter dataFilter, boolean caseSensitive, ParamsBinder params, String afterFrom, String additionalConditions, String additionalSort) {
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("from ");
        sqlQuery.append(this.dtoClass.getName());
        sqlQuery.append(" as main");
        if (StringUtil.isNotEmpty((String)afterFrom)) {
            sqlQuery.append(" ");
            sqlQuery.append(afterFrom);
        }
        if (params == null) {
            params = new ParamsBinder();
        }
        StringBuilder filterQuery = new StringBuilder();
        if (dataFilter.getFilter() != null) {
            try {
                this.addFilter(filterQuery, params, dataFilter.getFilter(), caseSensitive);
            }
            catch (Exception e) {
                LOGGER.error("Error adding filters", (Throwable)e);
            }
        }
        if (filterQuery.length() > 0 || StringUtil.isNotEmpty((String)additionalConditions)) {
            sqlQuery.append(" where");
            if (filterQuery.length() > 0) {
                sqlQuery.append((CharSequence)filterQuery);
                if (StringUtil.isNotEmpty((String)additionalConditions)) {
                    sqlQuery.append(" and");
                }
            }
            if (StringUtil.isNotEmpty((String)additionalConditions)) {
                sqlQuery.append(" ");
                sqlQuery.append(additionalConditions);
            }
        }
        Long totalRowCount = 0L;
        if (dataFilter.isFetchTotalCount()) {
            Query<?> query = this.createQuery("select count(main) " + sqlQuery.toString());
            params.bindParams(query);
            totalRowCount = (Long)query.getSingleResult();
        }
        boolean hasMore = false;
        LinkedList<Pojo> list = new LinkedList<Pojo>();
        if (dataFilter.isFetchList()) {
            StringBuilder sortQuery = new StringBuilder();
            try {
                this.addSort(sortQuery, dataFilter.getSort());
            }
            catch (Exception e) {
                LOGGER.error("Error adding sort conditions", (Throwable)e);
            }
            if (StringUtil.isNotEmpty((String)additionalSort)) {
                if (sortQuery.length() > 0) {
                    sqlQuery.append((CharSequence)sortQuery);
                    sqlQuery.append(", ");
                }
                sqlQuery.append(additionalSort);
            } else if (sortQuery.length() > 0) {
                sqlQuery.append((CharSequence)sortQuery);
            }
            Query<?> query = this.createQuery("select main " + sqlQuery.toString());
            params.bindParams(query);
            if (dataFilter.getStartIndex() != null) {
                query.setFirstResult(dataFilter.getStartIndex().intValue());
            }
            if (dataFilter.getItemLimit() != null) {
                if (dataFilter.isFetchHasMore()) {
                    query.setMaxResults(dataFilter.getItemLimit() + 1);
                } else {
                    query.setMaxResults(dataFilter.getItemLimit().intValue());
                }
            }
            List result = query.getResultList();
            for (Object item : result) {
                Dto dto = (Dto)item;
                Pojo pojo = (Pojo)this.getAdapterPool().create(this.pojoClass, dto);
                list.add(pojo);
            }
            if (dataFilter.getItemLimit() != null && dataFilter.isFetchHasMore() && list.size() > dataFilter.getItemLimit()) {
                list.removeLast();
                hasMore = true;
            }
        }
        ListDataResult dataResult = new ListDataResult();
        dataResult.setData(list);
        dataResult.setTotalCount(totalRowCount);
        dataResult.setDisplayItemsPerPage(dataFilter.getItemLimit());
        dataResult.setHasMore(hasMore);
        this.flush();
        return dataResult;
    }
}

