/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.audio.producer;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import nl.captcha.audio.Sample;
import nl.captcha.audio.producer.VoiceProducer;
import nl.captcha.util.FileUtil;

public class RandomNumberVoiceProducer
implements VoiceProducer {
    private static final Random RAND = new SecureRandom();
    private static final String[] DEFAULT_VOICES = new String[]{"alex", "bruce", "fred", "ralph", "kathy", "vicki", "victoria"};
    private static final Map<Integer, String[]> DEFAULT_VOICES_MAP = new HashMap<Integer, String[]>();
    private final Map<Integer, String[]> _voices;

    static {
        int i = 0;
        while (i < 10) {
            String[] files_for_num = new String[DEFAULT_VOICES.length];
            int j = 0;
            while (j < files_for_num.length) {
                StringBuilder sb = new StringBuilder("/sounds/en/numbers/");
                sb.append(i);
                sb.append("-");
                sb.append(DEFAULT_VOICES[j]);
                sb.append(".wav");
                files_for_num[j] = sb.toString();
                ++j;
            }
            DEFAULT_VOICES_MAP.put(i, files_for_num);
            ++i;
        }
    }

    public RandomNumberVoiceProducer() {
        this(DEFAULT_VOICES_MAP);
    }

    public RandomNumberVoiceProducer(Map<Integer, String[]> voices) {
        this._voices = voices;
    }

    public Map<Integer, String[]> getVoices() {
        return Collections.unmodifiableMap(this._voices);
    }

    @Override
    public final Sample getVocalization(char num) {
        try {
            Integer.parseInt(String.valueOf(num));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected <num> to be a number, got '" + num + "' instead.", e);
        }
        int idx = Integer.parseInt(String.valueOf(num));
        String[] files = this._voices.get(idx);
        String filename = files[RAND.nextInt(files.length)];
        return FileUtil.readSample(filename);
    }
}

