/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.documents.docx;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.imageio.ImageIO;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.documents.DocumentException;
import si.nevensrok.common.documents.common.Alignment;
import si.nevensrok.common.documents.common.Border;
import si.nevensrok.common.documents.common.Content;
import si.nevensrok.common.documents.common.Document;
import si.nevensrok.common.documents.common.Image;
import si.nevensrok.common.documents.common.LineList;
import si.nevensrok.common.documents.common.PageBreak;
import si.nevensrok.common.documents.common.Paragraph;
import si.nevensrok.common.documents.common.Table;
import si.nevensrok.common.documents.common.TableCell;
import si.nevensrok.common.documents.common.TableRow;
import si.nevensrok.common.documents.common.VerticalAlignment;

public class DocxDocumentBuilder {
    private static final Logger log = LoggerFactory.getLogger(DocxDocumentBuilder.class);
    private static final float dimensionFactor = 30.0f;
    private static final int imageBufferSize = 65536;
    private Document document;
    private OutputStream outputStream;
    private XWPFDocument xwpfDocument = null;
    private boolean addPageBreak = false;
    private int imageCounter = 1;

    public DocxDocumentBuilder(Document document, OutputStream outputStream) {
        this.document = document;
        this.outputStream = outputStream;
    }

    public void build() throws DocumentException {
        log.trace("Building docx document");
        try {
            this.xwpfDocument = new XWPFDocument();
            for (Content content : this.document.getContentList()) {
                if (content instanceof PageBreak) {
                    this.addPageBreak = true;
                    continue;
                }
                if (content instanceof Paragraph) {
                    this.addParagraph((Paragraph)content);
                    continue;
                }
                if (content instanceof LineList) {
                    this.addLineList((LineList)content);
                    continue;
                }
                if (content instanceof Table) {
                    this.addTable((Table)content);
                    continue;
                }
                if (content instanceof Image) {
                    this.addImage((Image)content);
                    continue;
                }
                log.error("Unsupported content type {}", (Object)content.getClass().getName());
            }
            this.xwpfDocument.write(this.outputStream);
        }
        catch (DocumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocumentException("Error creating docx document", e);
        }
    }

    private void addParagraph(Paragraph paragraph) {
        XWPFParagraph xwpfParagraph = this.xwpfDocument.createParagraph();
        if (this.addPageBreak) {
            xwpfParagraph.setPageBreak(true);
            this.addPageBreak = false;
        }
        if (paragraph.getAlignment() == Alignment.LEFT) {
            xwpfParagraph.setAlignment(ParagraphAlignment.LEFT);
        } else if (paragraph.getAlignment() == Alignment.CENTER) {
            xwpfParagraph.setAlignment(ParagraphAlignment.CENTER);
        } else if (paragraph.getAlignment() == Alignment.RIGHT) {
            xwpfParagraph.setAlignment(ParagraphAlignment.RIGHT);
        } else if (paragraph.getAlignment() == Alignment.JUSTIFY) {
            xwpfParagraph.setAlignment(ParagraphAlignment.BOTH);
        }
        xwpfParagraph.setIndentationLeft(Math.round(paragraph.getMargin().getLeft() * 30.0f));
        xwpfParagraph.setIndentationRight(Math.round(paragraph.getMargin().getRight() * 30.0f));
        xwpfParagraph.setSpacingBefore(Math.round(paragraph.getMargin().getTop() * 30.0f));
        xwpfParagraph.setSpacingAfter(Math.round(paragraph.getMargin().getBottom() * 30.0f));
        XWPFRun xwpfRun = xwpfParagraph.createRun();
        xwpfRun.setText(paragraph.getText());
        switch (paragraph.getFontType()) {
            case DejaVuSans: {
                xwpfRun.setFontFamily("SansSerif");
            }
        }
        xwpfRun.setFontSize(Math.round(paragraph.getFontSize().floatValue()));
        xwpfRun.setColor(this.getHexColor(paragraph.getColor()));
        if (paragraph.getBold().booleanValue()) {
            xwpfRun.setBold(true);
        }
        if (paragraph.getItalic().booleanValue()) {
            xwpfRun.setItalic(true);
        }
    }

    private String getHexColor(Color color) {
        StringBuilder hexColor = new StringBuilder();
        String r = Integer.toHexString(color.getRed());
        if (r.length() < 2) {
            hexColor.append("0");
        }
        hexColor.append(r);
        String g = Integer.toHexString(color.getGreen());
        if (g.length() < 2) {
            hexColor.append("0");
        }
        hexColor.append(g);
        String b = Integer.toHexString(color.getBlue());
        if (b.length() < 2) {
            hexColor.append("0");
        }
        hexColor.append(b);
        return hexColor.toString().toUpperCase();
    }

    private void addLineList(LineList lineList) throws IOException, XmlException {
        log.trace("Adding line list content");
        XWPFNumbering xwpfNumbering = this.xwpfDocument.createNumbering();
        CTAbstractNum ctAbstractNum = null;
        ctAbstractNum = lineList.getIconType() == LineList.IconType.CIRCLE ? CTAbstractNum.Factory.parse((InputStream)DocxDocumentBuilder.class.getResourceAsStream("/si/nevensrok/common/documents/docx/numbering/bullet.xml")) : (lineList.getIconType() == LineList.IconType.NUMERIC ? CTAbstractNum.Factory.parse((InputStream)DocxDocumentBuilder.class.getResourceAsStream("/si/nevensrok/common/documents/docx/numbering/number.xml")) : (lineList.getIconType() == LineList.IconType.LOWER_LETTERS ? CTAbstractNum.Factory.parse((InputStream)DocxDocumentBuilder.class.getResourceAsStream("/si/nevensrok/common/documents/docx/numbering/lower-letter.xml")) : (lineList.getIconType() == LineList.IconType.UPPER_LETTERS ? CTAbstractNum.Factory.parse((InputStream)DocxDocumentBuilder.class.getResourceAsStream("/si/nevensrok/common/documents/docx/numbering/upper-letter.xml")) : CTAbstractNum.Factory.newInstance())));
        XWPFAbstractNum xwpfAbstractNum = new XWPFAbstractNum(ctAbstractNum, xwpfNumbering);
        BigInteger id = BigInteger.ONE;
        while (xwpfNumbering.getAbstractNum(id) != null) {
            id = id.add(BigInteger.ONE);
        }
        xwpfAbstractNum.getAbstractNum().setAbstractNumId(id);
        xwpfNumbering.addAbstractNum(xwpfAbstractNum);
        this.xwpfDocument.getNumbering().addNum(id);
        for (String line : lineList.getLines()) {
            XWPFParagraph xwpfParagraph = this.xwpfDocument.createParagraph();
            if (this.addPageBreak) {
                xwpfParagraph.setPageBreak(true);
                this.addPageBreak = false;
            }
            xwpfParagraph.setNumID(id);
            XWPFRun xwpfRun = xwpfParagraph.createRun();
            xwpfRun.setText(line);
        }
    }

    private void addTable(Table table) {
        log.trace("Adding table content");
        if (this.addPageBreak) {
            XWPFParagraph xwpfParagraph = this.xwpfDocument.createParagraph();
            xwpfParagraph.setPageBreak(true);
            this.addPageBreak = false;
        }
        int rows = 0;
        int cols = 0;
        for (TableRow tableRow : table.getTableRows()) {
            ++rows;
            cols = Math.max(cols, tableRow.getTableCells().size());
        }
        XWPFTable xwpfTable = this.xwpfDocument.createTable(rows, cols);
        int rowIndex = 0;
        for (TableRow tableRow : table.getTableRows()) {
            int colIndex = 0;
            for (TableCell tableCell : tableRow.getTableCells()) {
                XWPFTableCell xwpfTableCell = xwpfTable.getRow(rowIndex).getCell(colIndex);
                if (tableCell.getVerticalAlignment() == VerticalAlignment.BOTTOM) {
                    xwpfTableCell.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.BOTTOM);
                } else if (tableCell.getVerticalAlignment() == VerticalAlignment.MIDDLE) {
                    xwpfTableCell.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.CENTER);
                } else if (tableCell.getVerticalAlignment() == VerticalAlignment.TOP) {
                    xwpfTableCell.setVerticalAlignment(XWPFTableCell.XWPFVertAlign.TOP);
                }
                CTTc ctTc = xwpfTableCell.getCTTc();
                CTTcPr tcPr = ctTc.getTcPr();
                CTTcBorders border = tcPr.addNewTcBorders();
                if (tableCell.getCellBorder().getLeft().getBorderType() == Border.BorderType.LINE) {
                    border.addNewLeft().setVal(STBorder.SINGLE);
                } else {
                    border.addNewLeft().setVal(STBorder.NONE);
                }
                if (tableCell.getCellBorder().getTop().getBorderType() == Border.BorderType.LINE) {
                    border.addNewTop().setVal(STBorder.SINGLE);
                } else {
                    border.addNewTop().setVal(STBorder.NONE);
                }
                if (tableCell.getCellBorder().getRight().getBorderType() == Border.BorderType.LINE) {
                    border.addNewRight().setVal(STBorder.SINGLE);
                } else {
                    border.addNewRight().setVal(STBorder.NONE);
                }
                if (tableCell.getCellBorder().getBottom().getBorderType() == Border.BorderType.LINE) {
                    border.addNewBottom().setVal(STBorder.SINGLE);
                } else {
                    border.addNewBottom().setVal(STBorder.NONE);
                }
                for (Paragraph paragraph : tableCell.getContentList()) {
                    XWPFParagraph xwpfParagraph = xwpfTableCell.addParagraph();
                    if (paragraph.getAlignment() == Alignment.LEFT) {
                        xwpfParagraph.setAlignment(ParagraphAlignment.LEFT);
                    } else if (paragraph.getAlignment() == Alignment.CENTER) {
                        xwpfParagraph.setAlignment(ParagraphAlignment.CENTER);
                    } else if (paragraph.getAlignment() == Alignment.RIGHT) {
                        xwpfParagraph.setAlignment(ParagraphAlignment.RIGHT);
                    } else if (paragraph.getAlignment() == Alignment.JUSTIFY) {
                        xwpfParagraph.setAlignment(ParagraphAlignment.BOTH);
                    }
                    xwpfParagraph.setIndentationLeft(Math.round(paragraph.getMargin().getLeft() * 30.0f));
                    xwpfParagraph.setIndentationRight(Math.round(paragraph.getMargin().getRight() * 30.0f));
                    xwpfParagraph.setSpacingBefore(Math.round(paragraph.getMargin().getTop() * 30.0f));
                    xwpfParagraph.setSpacingAfter(Math.round(paragraph.getMargin().getBottom() * 30.0f));
                    XWPFRun xwpfRun = xwpfParagraph.createRun();
                    xwpfRun.setText(paragraph.getText());
                    switch (paragraph.getFontType()) {
                        case DejaVuSans: {
                            xwpfRun.setFontFamily("SansSerif");
                        }
                    }
                    xwpfRun.setFontSize(Math.round(paragraph.getFontSize().floatValue()));
                    xwpfRun.setColor(this.getHexColor(paragraph.getColor()));
                    if (paragraph.getBold().booleanValue()) {
                        xwpfRun.setBold(true);
                    }
                    if (!paragraph.getItalic().booleanValue()) continue;
                    xwpfRun.setItalic(true);
                }
                ++colIndex;
            }
            ++rowIndex;
        }
    }

    private void addImage(Image image) throws IOException, InvalidFormatException {
        XWPFParagraph xwpfParagraph = this.xwpfDocument.createParagraph();
        if (this.addPageBreak) {
            xwpfParagraph.setPageBreak(true);
            this.addPageBreak = false;
        }
        if (image.getAlignment() == Alignment.LEFT) {
            xwpfParagraph.setAlignment(ParagraphAlignment.LEFT);
        } else if (image.getAlignment() == Alignment.CENTER) {
            xwpfParagraph.setAlignment(ParagraphAlignment.CENTER);
        } else if (image.getAlignment() == Alignment.RIGHT) {
            xwpfParagraph.setAlignment(ParagraphAlignment.RIGHT);
        } else if (image.getAlignment() == Alignment.JUSTIFY) {
            xwpfParagraph.setAlignment(ParagraphAlignment.BOTH);
        }
        xwpfParagraph.setIndentationLeft(Math.round(image.getMargin().getLeft() * 30.0f));
        xwpfParagraph.setIndentationRight(Math.round(image.getMargin().getRight() * 30.0f));
        xwpfParagraph.setSpacingBefore(Math.round(image.getMargin().getTop() * 30.0f));
        xwpfParagraph.setSpacingAfter(Math.round(image.getMargin().getBottom() * 30.0f));
        XWPFRun xwpfRun = xwpfParagraph.createRun();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        ImageIO.write((RenderedImage)image.getImageData(), "PNG", buffer);
        int width = image.getImageData().getWidth();
        int height = image.getImageData().getHeight();
        xwpfRun.addPicture((InputStream)new ByteArrayInputStream(buffer.toByteArray()), 6, "Image" + this.imageCounter + ".png", width, height);
        ++this.imageCounter;
    }
}

