/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.uuid;

import java.util.Calendar;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.uuid.MachineIdGenerator;
import si.nevensrok.common.uuid.UUIDGenerator;
import si.nevensrok.common.uuid.UUIDUtil;

public class SequenceUUIDGenerator
implements UUIDGenerator,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SequenceUUIDGenerator.class);
    private int sequence = 0;
    private Object sequenceLock = new Object();
    private Integer machineId = null;
    private MachineIdGenerator machineIdGenerator;

    public void setMachineId(Integer machineId) {
        this.machineId = machineId;
    }

    public void setMachineIdGenerator(MachineIdGenerator machineIdGenerator) {
        this.machineIdGenerator = machineIdGenerator;
    }

    public void afterPropertiesSet() throws Exception {
        Random random = new Random();
        if (this.machineId == null && this.machineIdGenerator != null) {
            log.debug("Generating machine id by mac");
            this.machineId = this.machineIdGenerator.generateMachineId();
        }
        if (this.machineId == null) {
            log.debug("Generating random machine id");
            this.machineId = random.nextInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID generateUUID() {
        byte[] uuidBytes = new byte[16];
        long time = 0L;
        Calendar calendar = Calendar.getInstance();
        time += (long)Math.abs(calendar.get(1)) * 10000000000L;
        time += (long)Math.abs(calendar.get(2)) * 100000000L;
        time += (long)Math.abs(calendar.get(5)) * 1000000L;
        time += (long)Math.abs(calendar.get(11)) * 10000L;
        time += (long)Math.abs(calendar.get(12)) * 100L;
        uuidBytes[0] = (byte)((time += (long)Math.abs(calendar.get(13))) >> 40 & 0xFFL);
        uuidBytes[1] = (byte)(time >> 32 & 0xFFL);
        uuidBytes[2] = (byte)(time >> 24 & 0xFFL);
        uuidBytes[3] = (byte)(time >> 16 & 0xFFL);
        uuidBytes[4] = (byte)(time >> 8 & 0xFFL);
        uuidBytes[5] = (byte)(time & 0xFFL);
        uuidBytes[7] = (byte)(this.machineId >> 24 & 0xFF);
        uuidBytes[9] = (byte)(this.machineId >> 16 & 0xFF);
        uuidBytes[10] = (byte)(this.machineId >> 8 & 0xFF);
        uuidBytes[11] = (byte)(this.machineId & 0xFF);
        int num = 0;
        Object object = this.sequenceLock;
        synchronized (object) {
            num = this.sequence++;
        }
        uuidBytes[12] = (byte)(num >> 24 & 0xFF);
        uuidBytes[13] = (byte)(num >> 16 & 0xFF);
        uuidBytes[14] = (byte)(num >> 8 & 0xFF);
        uuidBytes[15] = (byte)(num & 0xFF);
        uuidBytes[6] = (byte)(uuidBytes[6] & 0xF);
        uuidBytes[6] = (byte)(uuidBytes[6] | 0x40);
        uuidBytes[8] = (byte)(uuidBytes[8] & 0x3F);
        uuidBytes[8] = (byte)(uuidBytes[8] | 0x80);
        return UUIDUtil.generateFromBytes(uuidBytes);
    }
}

