/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.thresholdutil;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.threads.ThreadUtil;
import si.nevensrok.common.thresholdutil.MethodExecutor;
import si.nevensrok.common.thresholdutil.SharedData;
import si.nevensrok.common.thresholdutil.ThresholdConfigurationProvider;

public class ThresholdService {
    private static final Logger log = LoggerFactory.getLogger(ThresholdService.class);
    private MethodExecutor methodExecutor;
    private ThresholdConfigurationProvider tresholdConfigurationProvider;
    private int threads = 1;
    private Executor executor;
    private boolean started = false;

    public MethodExecutor getMethodExecutor() {
        return this.methodExecutor;
    }

    public void setMethodExecutor(MethodExecutor methodExecutor) {
        this.methodExecutor = methodExecutor;
    }

    public ThresholdConfigurationProvider getTresholdConfigurationProvider() {
        return this.tresholdConfigurationProvider;
    }

    public void setTresholdConfigurationProvider(ThresholdConfigurationProvider tresholdConfigurationProvider) {
        this.tresholdConfigurationProvider = tresholdConfigurationProvider;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public synchronized void start() {
        if (this.methodExecutor == null) {
            throw new RuntimeException("Property 'methodExecutor' must be provided");
        }
        if (this.tresholdConfigurationProvider == null) {
            throw new RuntimeException("Property 'tresholdConfigurationProvider' must be provided");
        }
        if (this.threads < 1) {
            throw new RuntimeException("Threads must be number 1 or higher");
        }
        if (this.started) {
            return;
        }
        this.started = true;
        final SharedData sharedData = new SharedData();
        for (int i = 0; i < this.threads; ++i) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SharedData sharedData3 = sharedData;
                        synchronized (sharedData3) {
                            if (!sharedData.beforeExecuted) {
                                sharedData.beforeExecuted = true;
                                ThresholdService.this.methodExecutor.before();
                            }
                        }
                        while (ThresholdService.this.started) {
                            long sleepTime = 0L;
                            boolean executeMethod = true;
                            SharedData sharedData2 = sharedData;
                            synchronized (sharedData2) {
                                long sleepFinishTime;
                                long sleepTimeForBurst;
                                long sleepTimeForTotal;
                                if (sharedData.currentThresholdConfiguration != null && sharedData.currentThresholdConfiguration.getValidUntil() != null && sharedData.currentThresholdConfiguration.getValidUntil().getTimeInMillis() < System.currentTimeMillis()) {
                                    sharedData.currentThresholdConfiguration = null;
                                }
                                if (sharedData.currentThresholdConfiguration == null) {
                                    sharedData.currentThresholdConfiguration = Objects.requireNonNull(ThresholdService.this.tresholdConfigurationProvider.getTresholdConfiguration(), "Treshold configuration is null");
                                    if (sharedData.currentThresholdConfiguration.getExecutionsPerSecond() <= 0.0) {
                                        throw new IllegalArgumentException("Executions per second must be number bigger than 0");
                                    }
                                    sharedData.startTime = System.currentTimeMillis();
                                    sharedData.methodExecutedCount = 0L;
                                    sharedData.burstStartTime = System.currentTimeMillis();
                                    sharedData.burstExecutionCount = 0L;
                                }
                                if ((sleepTime = Math.max(sleepTimeForTotal = ThresholdService.this.getSleepTimeForTotal(sharedData), sleepTimeForBurst = ThresholdService.this.getSleepTimeForBurst(sharedData))) > 0L && sharedData.currentThresholdConfiguration.getValidUntil() != null && (sleepFinishTime = System.currentTimeMillis() + sleepTime) > sharedData.currentThresholdConfiguration.getValidUntil().getTimeInMillis()) {
                                    sleepTime = sharedData.currentThresholdConfiguration.getValidUntil().getTimeInMillis() - System.currentTimeMillis() + 1L;
                                    executeMethod = false;
                                }
                                if (executeMethod) {
                                    ++sharedData.methodExecutedCount;
                                    ++sharedData.burstExecutionCount;
                                }
                            }
                            if (sleepTime > 0L) {
                                try {
                                    Thread.sleep(sleepTime);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if (!executeMethod || !ThresholdService.this.started || ThresholdService.this.methodExecutor.execute()) continue;
                            ThresholdService.this.started = false;
                        }
                    }
                    catch (Throwable e) {
                        ThresholdService.this.started = false;
                        log.error("Error while executing methods", e);
                    }
                    try {
                        SharedData e = sharedData;
                        synchronized (e) {
                            if (!sharedData.afterExecuted) {
                                sharedData.afterExecuted = true;
                                ThresholdService.this.methodExecutor.after();
                            }
                        }
                    }
                    catch (Throwable e) {
                        log.error("Error executing after method", e);
                    }
                }
            };
            if (this.executor != null) {
                this.executor.execute(runnable);
                continue;
            }
            ThreadUtil.runInBackground(runnable);
        }
    }

    public synchronized void stop() {
        this.started = false;
    }

    public long getSleepTimeForTotal(SharedData sharedData) {
        long duration = System.currentTimeMillis() - sharedData.startTime;
        if (duration < 0L) {
            duration = 0L;
        }
        double shouldSendByNow = (double)duration / 1000.0 * sharedData.currentThresholdConfiguration.getExecutionsPerSecond();
        return Math.round(((double)sharedData.methodExecutedCount - shouldSendByNow) / sharedData.currentThresholdConfiguration.getExecutionsPerSecond() * 1000.0);
    }

    public long getSleepTimeForBurst(SharedData sharedData) {
        if (sharedData.currentThresholdConfiguration.getBurstTime() <= 0L) {
            return 0L;
        }
        if (sharedData.currentThresholdConfiguration.getBurstFactor() <= 1.0) {
            return 0L;
        }
        long duration = System.currentTimeMillis() - sharedData.burstStartTime;
        if (duration < 0L) {
            duration = 0L;
        }
        if (duration > sharedData.currentThresholdConfiguration.getBurstTime()) {
            duration = 0L;
            sharedData.burstStartTime = System.currentTimeMillis();
            sharedData.burstExecutionCount = 0L;
        }
        double burstSendFactor = sharedData.currentThresholdConfiguration.getExecutionsPerSecond() * sharedData.currentThresholdConfiguration.getBurstFactor();
        double shouldSendByNow = (double)duration / 1000.0 * burstSendFactor;
        return Math.round(((double)sharedData.burstExecutionCount - shouldSendByNow) / burstSendFactor * 1000.0);
    }
}

