/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.AccessHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Effect {
    public static final Effect DefaultInput = null;
    private final List<Effect> inputs;
    private final List<Effect> unmodifiableInputs;
    private final int maxInputs;

    protected Effect() {
        this.inputs = Collections.emptyList();
        this.unmodifiableInputs = this.inputs;
        this.maxInputs = 0;
    }

    protected Effect(Effect input) {
        this.inputs = new ArrayList<Effect>(1);
        this.unmodifiableInputs = Collections.unmodifiableList(this.inputs);
        this.maxInputs = 1;
        this.setInput(0, input);
    }

    protected Effect(Effect input1, Effect input2) {
        this.inputs = new ArrayList<Effect>(2);
        this.unmodifiableInputs = Collections.unmodifiableList(this.inputs);
        this.maxInputs = 2;
        this.setInput(0, input1);
        this.setInput(1, input2);
    }

    Object getState() {
        return null;
    }

    public int getNumInputs() {
        return this.inputs.size();
    }

    public final List<Effect> getInputs() {
        return this.unmodifiableInputs;
    }

    protected void setInput(int index, Effect input) {
        if (index < 0 || index >= this.maxInputs) {
            throw new IllegalArgumentException("Index must be within allowable range");
        }
        if (index < this.inputs.size()) {
            this.inputs.set(index, input);
        } else {
            this.inputs.add(input);
        }
    }

    public static BaseBounds combineBounds(BaseBounds ... inputBounds) {
        BaseBounds ret = null;
        if (inputBounds.length == 1) {
            ret = inputBounds[0];
        } else {
            for (int i = 0; i < inputBounds.length; ++i) {
                BaseBounds r = inputBounds[i];
                if (r == null || r.isEmpty()) continue;
                if (ret == null) {
                    ret = new RectBounds();
                    ret = ret.deriveWithNewBounds(r);
                    continue;
                }
                ret = ret.deriveWithUnion(r);
            }
        }
        if (ret == null) {
            ret = new RectBounds();
        }
        return ret;
    }

    public static Rectangle combineBounds(Rectangle ... inputBounds) {
        Rectangle ret = null;
        if (inputBounds.length == 1) {
            ret = inputBounds[0];
        } else {
            for (int i = 0; i < inputBounds.length; ++i) {
                Rectangle r = inputBounds[i];
                if (r == null || r.isEmpty()) continue;
                if (ret == null) {
                    ret = new Rectangle(r);
                    continue;
                }
                ret.add(r);
            }
        }
        if (ret == null) {
            ret = new Rectangle();
        }
        return ret;
    }

    public Rectangle getResultBounds(BaseTransform transform, Rectangle outputClip, ImageData ... inputDatas) {
        int numinputs = inputDatas.length;
        Rectangle[] inputBounds = new Rectangle[numinputs];
        for (int i = 0; i < numinputs; ++i) {
            inputBounds[i] = inputDatas[i].getTransformedBounds(outputClip);
        }
        Rectangle rb = Effect.combineBounds(inputBounds);
        return rb;
    }

    public abstract ImageData filter(FilterContext var1, BaseTransform var2, Rectangle var3, Object var4, Effect var5);

    public static BaseBounds transformBounds(BaseTransform tx, BaseBounds r) {
        if (tx == null || tx.isIdentity()) {
            return r;
        }
        BaseBounds ret = new RectBounds();
        ret = tx.transform(r, ret);
        return ret;
    }

    protected ImageData ensureTransform(FilterContext fctx, ImageData original, BaseTransform transform, Rectangle clip) {
        if (transform == null || transform.isIdentity()) {
            return original;
        }
        if (!original.validate(fctx)) {
            original.unref();
            return new ImageData(fctx, null, new Rectangle());
        }
        return original.transform(transform);
    }

    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        DirtyRegionContainer merge = null;
        for (int i = 0; i < this.inputs.size(); ++i) {
            DirtyRegionContainer drc = this.getDefaultedInput(i, defaultInput).getDirtyRegions(defaultInput, regionPool);
            if (merge == null) {
                merge = drc;
                continue;
            }
            merge.merge(drc);
            regionPool.checkIn(drc);
        }
        if (merge == null) {
            merge = regionPool.checkOut();
        }
        return merge;
    }

    Effect getDefaultedInput(int inputIndex, Effect defaultInput) {
        return Effect.getDefaultedInput(this.inputs.get(inputIndex), defaultInput);
    }

    static Effect getDefaultedInput(Effect listedInput, Effect defaultInput) {
        return listedInput == null ? defaultInput : listedInput;
    }

    public abstract BaseBounds getBounds(BaseTransform var1, Effect var2);

    public Point2D transform(Point2D p, Effect defaultInput) {
        return p;
    }

    public Point2D untransform(Point2D p, Effect defaultInput) {
        return p;
    }

    public static Filterable createCompatibleImage(FilterContext fctx, int w, int h) {
        return Renderer.getRenderer(fctx).createCompatibleImage(w, h);
    }

    public static Filterable getCompatibleImage(FilterContext fctx, int w, int h) {
        return Renderer.getRenderer(fctx).getCompatibleImage(w, h);
    }

    public static void releaseCompatibleImage(FilterContext fctx, Filterable image) {
        Renderer.getRenderer(fctx).releaseCompatibleImage(image);
    }

    public abstract boolean reducesOpaquePixels();

    public abstract AccelType getAccelType(FilterContext var1);

    static {
        AccessHelper.setStateAccessor(effect -> effect.getState());
    }

    public static enum AccelType {
        INTRINSIC("Intrinsic"),
        NONE("CPU/Java"),
        SIMD("CPU/SIMD"),
        FIXED("CPU/Fixed"),
        OPENGL("OpenGL"),
        DIRECT3D("Direct3D");

        private String text;

        private AccelType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

