/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.security;

import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import si.nevensrok.jtekma.common.system.AutologinToken;
import si.nevensrok.jtekma.server.management.AutologinTokenManager;

public class AutologinTokenRepository
implements PersistentTokenRepository {
    private static final Logger log = LoggerFactory.getLogger(AutologinTokenRepository.class);
    private AutologinTokenManager autologinTokenManager;
    private int cookieExpiryTime = 1209600;

    public void setAutologinTokenManager(AutologinTokenManager autologinTokenManager) {
        this.autologinTokenManager = autologinTokenManager;
    }

    public void setCookieExpiryTime(int cookieExpiryTime) {
        this.cookieExpiryTime = cookieExpiryTime;
    }

    public void createNewToken(PersistentRememberMeToken token) {
        AutologinToken autologinToken = new AutologinToken(token.getSeries(), token.getUsername(), token.getTokenValue(), token.getDate());
        if (log.isDebugEnabled()) {
            log.debug("Creating token {}", (Object)autologinToken);
        }
        this.autologinTokenManager.createAutologinToken(autologinToken);
    }

    public void updateToken(String series, String tokenValue, Date lastUsed) {
        AutologinToken autologinToken = new AutologinToken(series, null, tokenValue, lastUsed);
        if (log.isDebugEnabled()) {
            log.debug("Updating token {}", (Object)autologinToken);
        }
        this.autologinTokenManager.updateAutologinToken(autologinToken);
    }

    public PersistentRememberMeToken getTokenForSeries(String seriesId) {
        if (log.isDebugEnabled()) {
            log.debug("Fetching token for series {}", (Object)seriesId);
        }
        AutologinToken autologinToken = this.autologinTokenManager.getBySeries(seriesId);
        PersistentRememberMeToken persistentRememberMeToken = null;
        if (autologinToken != null) {
            persistentRememberMeToken = new PersistentRememberMeToken(autologinToken.getUsername(), autologinToken.getSeries(), autologinToken.getTokenValue(), autologinToken.getDate());
        }
        return persistentRememberMeToken;
    }

    public void removeUserTokens(String username) {
        if (log.isDebugEnabled()) {
            log.debug("Removign token for username {}", (Object)username);
        }
        this.autologinTokenManager.removeUserTokensForUsername(username);
    }

    public void removeExpiredTokens() {
        Calendar expirityDate = Calendar.getInstance();
        expirityDate.add(13, -this.cookieExpiryTime);
        this.autologinTokenManager.removeOlderTokens(expirityDate.getTime());
    }
}

