/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.data;

import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.data.ClubPlacingSettingsModel;

@Controller
@RequestMapping(value={"/data/club-placing"})
public class ClubPlacingSettingsController
extends CoreController {
    @ModelAttribute(value="clubPlacingSettingsActive")
    public Boolean getClubsActive() {
        return Boolean.TRUE;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String display(HttpServletRequest request, Model model, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode, @ModelAttribute(value="clubPlacingSettings") @Valid ClubPlacingSettingsModel clubPlacingSettings, BindingResult bindingResult) {
        Map competitionSettings = this.getManagersList().getCompetitionManager().getCompetitionSettings(this.getUserData().getCompetition());
        if (competitionSettings.get("clubPlacing.points.1") != null) {
            clubPlacingSettings.setPoints1(competitionSettings.get("clubPlacing.points.1") == null ? 10 : ((Long)competitionSettings.get("clubPlacing.points.1")).intValue());
        }
        if (competitionSettings.get("clubPlacing.points.2") != null) {
            clubPlacingSettings.setPoints2(competitionSettings.get("clubPlacing.points.2") == null ? 7 : ((Long)competitionSettings.get("clubPlacing.points.2")).intValue());
        }
        if (competitionSettings.get("clubPlacing.points.3") != null) {
            clubPlacingSettings.setPoints3(competitionSettings.get("clubPlacing.points.3") == null ? 5 : ((Long)competitionSettings.get("clubPlacing.points.3")).intValue());
        }
        if (competitionSettings.get("clubPlacing.points.4") != null) {
            clubPlacingSettings.setPoints4(competitionSettings.get("clubPlacing.points.4") == null ? 4 : ((Long)competitionSettings.get("clubPlacing.points.4")).intValue());
        }
        if (competitionSettings.get("clubPlacing.points.5") != null) {
            clubPlacingSettings.setPoints5(competitionSettings.get("clubPlacing.points.5") == null ? 3 : ((Long)competitionSettings.get("clubPlacing.points.5")).intValue());
        }
        if (competitionSettings.get("clubPlacing.points.6") != null) {
            clubPlacingSettings.setPoints6(competitionSettings.get("clubPlacing.points.6") == null ? 2 : ((Long)competitionSettings.get("clubPlacing.points.6")).intValue());
        }
        if (competitionSettings.get("clubPlacing.points.7") != null) {
            clubPlacingSettings.setPoints7(competitionSettings.get("clubPlacing.points.7") == null ? 1 : ((Long)competitionSettings.get("clubPlacing.points.7")).intValue());
        }
        boolean includeOneCompetitor = competitionSettings.get("clubPlacing.includeOneCompetitor") == null ? true : (Boolean)competitionSettings.get("clubPlacing.includeOneCompetitor");
        boolean includeSameClub = competitionSettings.get("clubPlacing.includeSameClub") == null ? true : (Boolean)competitionSettings.get("clubPlacing.includeSameClub");
        boolean includeAllCompetitors = competitionSettings.get("clubPlacing.includeAllCompetitors") == null ? false : (Boolean)competitionSettings.get("clubPlacing.includeAllCompetitors");
        clubPlacingSettings.setIncludeOneCompetitor(includeOneCompetitor);
        clubPlacingSettings.setIncludeSameClub(includeSameClub);
        clubPlacingSettings.setIncludeAllCompetitors(includeAllCompetitors);
        return "data/club-placing-settings";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String save(HttpServletRequest request, Model model, @ModelAttribute(value="clubPlacingSettings") @Valid ClubPlacingSettingsModel clubPlacingSettings, BindingResult bindingResult) {
        HashMap<String, Constable> competitionSettings = new HashMap<String, Constable>();
        competitionSettings.put("clubPlacing.points.1", clubPlacingSettings.getPoints1());
        competitionSettings.put("clubPlacing.points.2", clubPlacingSettings.getPoints2());
        competitionSettings.put("clubPlacing.points.3", clubPlacingSettings.getPoints3());
        competitionSettings.put("clubPlacing.points.4", clubPlacingSettings.getPoints4());
        competitionSettings.put("clubPlacing.points.5", clubPlacingSettings.getPoints5());
        competitionSettings.put("clubPlacing.points.6", clubPlacingSettings.getPoints6());
        competitionSettings.put("clubPlacing.points.7", clubPlacingSettings.getPoints7());
        competitionSettings.put("clubPlacing.includeOneCompetitor", clubPlacingSettings.getIncludeOneCompetitor());
        competitionSettings.put("clubPlacing.includeSameClub", clubPlacingSettings.getIncludeSameClub());
        competitionSettings.put("clubPlacing.includeAllCompetitors", clubPlacingSettings.getIncludeAllCompetitors());
        this.getManagersList().getCompetitionManager().setCompetitionSettings(this.getUserData().getCompetition(), competitionSettings, false);
        return "redirect:/data/club-placing";
    }
}

