/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.web.controllers.ChangePasswordModel;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.MyProfileModel;

@Controller
@RequestMapping(value={"/my-profile"})
public class MyProfileController
extends CoreController {
    @RequestMapping(method={RequestMethod.GET})
    public String viewData(HttpServletRequest request, Model model, @ModelAttribute(value="user") MyProfileModel myProfileModel, BindingResult bindingResult, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        model.addAttribute("myProfileActive", (Object)Boolean.TRUE);
        User user = this.getManagersList().getUserManager().getById(this.getUserData().getLoginedUser().getUserId());
        ObjectUtil.copyNotNullProperties((Object)user, (Object)myProfileModel);
        if (messageCode == 1) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "myProfile.text.saved"));
        } else if (messageCode == 2) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "myProfile.text.passwordChanged"));
        }
        return "my-profile/my-profile";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String postData(HttpServletRequest request, Model model, @ModelAttribute(value="user") @Valid MyProfileModel myProfileModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.viewData(request, model, myProfileModel, bindingResult, 0);
        }
        User user = this.getManagersList().getUserManager().getById(this.getUserData().getLoginedUser().getUserId());
        ObjectUtil.copyNotNullProperties((Object)myProfileModel, (Object)user);
        this.getManagersList().getUserManager().updateUser(user);
        return "redirect:/my-profile?messageCode=1";
    }

    @RequestMapping(value={"/password"}, method={RequestMethod.GET})
    public String changePassword(HttpServletRequest request, Model model, @ModelAttribute(value="password") ChangePasswordModel changePasswordModel, BindingResult bindingResult) {
        model.addAttribute("changePasswordActive", (Object)Boolean.TRUE);
        return "my-profile/change-password";
    }

    @RequestMapping(value={"/password"}, method={RequestMethod.POST})
    public String changePasswordPost(HttpServletRequest request, Model model, @ModelAttribute(value="password") @Valid ChangePasswordModel changePasswordModel, BindingResult bindingResult) {
        User user = this.getManagersList().getUserManager().getById(this.getUserData().getLoginedUser().getUserId());
        if (changePasswordModel.getCurrent() != null && !changePasswordModel.getCurrent().isEmpty() && !this.getManagersList().getUserManager().checkPassword(changePasswordModel.getCurrent(), user.getPassword())) {
            bindingResult.rejectValue("current", "myProfile.error.invalidCurrentPassword");
        }
        if (!(changePasswordModel.getNewPassword() == null || changePasswordModel.getNewPassword().isEmpty() || changePasswordModel.getConfirmation() == null || changePasswordModel.getConfirmation().isEmpty() || changePasswordModel.getNewPassword().equals(changePasswordModel.getConfirmation()))) {
            bindingResult.rejectValue("confirmation", "myProfile.error.invalidConfirmation");
        }
        if (bindingResult.hasErrors()) {
            return this.changePassword(request, model, changePasswordModel, bindingResult);
        }
        user.setPassword(changePasswordModel.getNewPassword());
        this.getManagersList().getUserManager().updateUsersPassword(user);
        return "redirect:/my-profile?messageCode=2";
    }
}

