/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.jobs;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import si.nevensrok.jtekma.common.competition.AutomationSettings;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.management.CompetitionAutomationManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;

public class CompetitionAutomationJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(CompetitionAutomationJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            log.debug("Competition automation job started");
            ApplicationContext applicationContext = (ApplicationContext)context.getScheduler().getContext().get((Object)"applicationContext");
            if (applicationContext == null) {
                throw new RuntimeException("ApplicationContext not found");
            }
            long competitionId = context.getJobDetail().getJobDataMap().getLong("competitionId");
            if (competitionId <= 0L) {
                throw new RuntimeException("CompetitionId not found");
            }
            CompetitionManager competitionManager = (CompetitionManager)applicationContext.getBean("jtekmaCompetitionManager");
            if (competitionManager == null) {
                throw new RuntimeException("CompetitionManager not found");
            }
            CompetitionAutomationManager competitionAutomationManager = (CompetitionAutomationManager)applicationContext.getBean("jtekmaCompetitionAutomationManager");
            if (competitionAutomationManager == null) {
                throw new RuntimeException("CompetitionAutomationManager not found");
            }
            Competition competition = competitionManager.getById(Long.valueOf(competitionId));
            if (competition == null) {
                this.unscheduleJob(context);
                throw new RuntimeException("Competition not found");
            }
            if (competition.getStatus() != Competition.Status.ACTIVE) {
                log.debug("Competition [{}] is not active", (Object)competition);
                this.unscheduleJob(context);
                return;
            }
            AutomationSettings automationSettings = competitionManager.getAutomationSettings(competition);
            if (automationSettings == null) {
                this.unscheduleJob(context);
                throw new RuntimeException("AutomationSettings not found");
            }
            if (automationSettings.getActive() == null || !automationSettings.getActive().booleanValue()) {
                log.debug("Automation is disabled for [{}]", (Object)competition);
                this.unscheduleJob(context);
                return;
            }
            if (this.isJobAlreadyRunning(context)) {
                log.debug("Competition automation job is already running");
                return;
            }
            competitionAutomationManager.putMatchesOnTatamis(competition);
            log.debug("Competition automation job finished");
        }
        catch (Exception e) {
            log.error("Error executing competition automation job", (Throwable)e);
        }
    }

    private void unscheduleJob(JobExecutionContext context) {
        log.debug("Unscheduling automation job [{}],[{}]", (Object)context.getTrigger().getKey().getName(), (Object)context.getTrigger().getKey().getGroup());
        try {
            context.getScheduler().unscheduleJob(context.getTrigger().getKey());
        }
        catch (Exception e) {
            log.error("Error unscheduling automation job", (Throwable)e);
        }
    }

    private boolean isJobAlreadyRunning(JobExecutionContext context) throws SchedulerException {
        int jobCounter = 0;
        for (JobExecutionContext jobExecutionContext : context.getScheduler().getCurrentlyExecutingJobs()) {
            if (!jobExecutionContext.getTrigger().getKey().equals((Object)context.getTrigger().getKey())) continue;
            ++jobCounter;
        }
        return jobCounter > 1;
    }
}

