/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.restclient;

import java.io.Serializable;
import java.util.Calendar;
import si.nevensrok.common.restclient.RestClientUtil;

public class Cookie
implements Serializable {
    private static final long serialVersionUID = 5632884154308487711L;
    private String name;
    private String value;
    private Calendar expires;
    private String path;
    private String domain;
    private Boolean httpOnly;
    private Boolean secure;

    public Cookie() {
    }

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Cookie(String name, String value, Calendar expires, String path, String domain, Boolean httpOnly, Boolean secure) {
        this.name = name;
        this.value = value;
        this.expires = expires;
        this.path = path;
        this.domain = domain;
        this.httpOnly = httpOnly;
        this.secure = secure;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Calendar getExpires() {
        return this.expires;
    }

    public void setExpires(Calendar expires) {
        this.expires = expires;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Boolean getHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(Boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(this.name);
        text.append("=");
        text.append(this.value);
        if (this.expires != null) {
            text.append("; Expires=");
            text.append(RestClientUtil.formatCalendar(this.expires));
        }
        if (this.path != null) {
            text.append("; Path=");
            text.append(this.path);
        }
        if (this.domain != null) {
            text.append("; Domain=");
            text.append(this.domain);
        }
        if (this.httpOnly != null && this.httpOnly.booleanValue()) {
            text.append("; HttpOnly");
        }
        if (this.secure != null && this.secure.booleanValue()) {
            text.append("; Secure");
        }
        return text.toString();
    }

    public static Cookie parse(String data) {
        Cookie cookie = new Cookie();
        String[] parts = data.split(";");
        String[] mainParts = parts[0].trim().split("=");
        String cookieName = mainParts[0].trim();
        String cookieValue = null;
        if (mainParts.length > 1) {
            cookieValue = mainParts[1].trim();
        }
        cookie.setName(cookieName);
        cookie.setValue(cookieValue);
        for (int i = 1; i < parts.length; ++i) {
            String[] subParts = parts[i].split("=");
            String key = subParts[0].trim();
            String value = null;
            if (subParts.length > 1) {
                value = subParts[1].trim();
            }
            if ("Expires".equalsIgnoreCase(key)) {
                cookie.setExpires(RestClientUtil.parseCalendar(value));
                continue;
            }
            if ("Path".equalsIgnoreCase(key)) {
                cookie.setPath(value);
                continue;
            }
            if ("Domain".equalsIgnoreCase(key)) {
                cookie.setDomain(value);
                continue;
            }
            if ("HttpOnly".equalsIgnoreCase(key)) {
                cookie.setHttpOnly(Boolean.TRUE);
                continue;
            }
            if (!"Secure".equalsIgnoreCase(key)) continue;
            cookie.setSecure(Boolean.TRUE);
        }
        return cookie;
    }
}

