/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;

final class ProcessImpl
extends Process {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private static final int VERIFICATION_CMD_BAT = 0;
    private static final int VERIFICATION_WIN32 = 1;
    private static final int VERIFICATION_WIN32_SAFE = 2;
    private static final int VERIFICATION_LEGACY = 3;
    private static final char[][] ESCAPE_VERIFICATION = new char[][]{{' ', '\t', '\"', '<', '>', '&', '|', '^'}, {' ', '\t', '\"', '<', '>'}, {' ', '\t', '\"', '<', '>'}, {' ', '\t'}};
    private static final char DOUBLEQUOTE = '\"';
    private static final char BACKSLASH = '\\';
    private long handle = 0L;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private InputStream stderr_stream;
    private static final int STILL_ACTIVE = ProcessImpl.getStillActive();

    private static FileOutputStream newFileOutputStream(File file, boolean bl) throws IOException {
        if (bl) {
            String string = file.getPath();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkWrite(string);
            }
            long l = ProcessImpl.openForAtomicAppend(string);
            final FileDescriptor fileDescriptor = new FileDescriptor();
            fdAccess.setHandle(fileDescriptor, l);
            return AccessController.doPrivileged(new PrivilegedAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() {
                    return new FileOutputStream(fileDescriptor);
                }
            });
        }
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Process start(String[] stringArray, Map<String, String> map, String string, ProcessBuilder.Redirect[] redirectArray, boolean bl) throws IOException {
        String string2 = ProcessEnvironment.toEnvironmentBlock(map);
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        try {
            long[] lArray;
            if (redirectArray == null) {
                lArray = new long[]{-1L, -1L, -1L};
            } else {
                lArray = new long[3];
                if (redirectArray[0] == ProcessBuilder.Redirect.PIPE) {
                    lArray[0] = -1L;
                } else if (redirectArray[0] == ProcessBuilder.Redirect.INHERIT) {
                    lArray[0] = fdAccess.getHandle(FileDescriptor.in);
                } else {
                    fileInputStream = new FileInputStream(redirectArray[0].file());
                    lArray[0] = fdAccess.getHandle(fileInputStream.getFD());
                }
                if (redirectArray[1] == ProcessBuilder.Redirect.PIPE) {
                    lArray[1] = -1L;
                } else if (redirectArray[1] == ProcessBuilder.Redirect.INHERIT) {
                    lArray[1] = fdAccess.getHandle(FileDescriptor.out);
                } else {
                    fileOutputStream = ProcessImpl.newFileOutputStream(redirectArray[1].file(), redirectArray[1].append());
                    lArray[1] = fdAccess.getHandle(fileOutputStream.getFD());
                }
                if (redirectArray[2] == ProcessBuilder.Redirect.PIPE) {
                    lArray[2] = -1L;
                } else if (redirectArray[2] == ProcessBuilder.Redirect.INHERIT) {
                    lArray[2] = fdAccess.getHandle(FileDescriptor.err);
                } else {
                    fileOutputStream2 = ProcessImpl.newFileOutputStream(redirectArray[2].file(), redirectArray[2].append());
                    lArray[2] = fdAccess.getHandle(fileOutputStream2.getFD());
                }
            }
            ProcessImpl processImpl = new ProcessImpl(stringArray, string2, string, lArray, bl);
            return processImpl;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                finally {
                    if (fileOutputStream2 != null) {
                        fileOutputStream2.close();
                    }
                }
            }
        }
    }

    private static String[] getTokensFromCommand(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(8);
        Matcher matcher = LazyPattern.PATTERN.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String createCommandLine(int n, String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(string);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(' ');
            String string2 = stringArray[i];
            if (ProcessImpl.needsEscaping(n, string2)) {
                int n2;
                stringBuilder.append('\"');
                if (n == 2) {
                    n2 = string2.length();
                    for (int j = 0; j < n2; ++j) {
                        char c = string2.charAt(j);
                        if (c == '\"') {
                            int n3 = ProcessImpl.countLeadingBackslash(n, string2, j);
                            while (n3-- > 0) {
                                stringBuilder.append('\\');
                            }
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(c);
                    }
                } else {
                    stringBuilder.append(string2);
                }
                n2 = ProcessImpl.countLeadingBackslash(n, string2, string2.length());
                while (n2-- > 0) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append('\"');
                continue;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static String unQuote(String string) {
        if (!string.startsWith("\"") || !string.endsWith("\"") || string.length() < 2) {
            return string;
        }
        if (string.endsWith("\\\"")) {
            return string;
        }
        return string.substring(1, string.length() - 1);
    }

    private static boolean needsEscaping(int n, String string) {
        if (string.isEmpty()) {
            return true;
        }
        String string2 = ProcessImpl.unQuote(string);
        boolean bl = !string.equals(string2);
        boolean bl2 = string2.indexOf(34) >= 0;
        switch (n) {
            case 0: {
                if (!bl2) break;
                throw new IllegalArgumentException("Argument has embedded quote, use the explicit CMD.EXE call.");
            }
            case 2: {
                if (!bl || !bl2) break;
                throw new IllegalArgumentException("Malformed argument has embedded quote: " + string2);
            }
        }
        if (!bl) {
            char[] cArray = ESCAPE_VERIFICATION[n];
            for (int i = 0; i < cArray.length; ++i) {
                if (string.indexOf(cArray[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static String getExecutablePath(String string) throws IOException {
        String string2 = ProcessImpl.unQuote(string);
        if (string2.indexOf(34) >= 0) {
            throw new IllegalArgumentException("Executable name has embedded quote, split the arguments: " + string2);
        }
        File file = new File(string2);
        return file.getPath();
    }

    private boolean isExe(String string) {
        File file = new File(string);
        String string2 = file.getName().toUpperCase(Locale.ROOT);
        return string2.endsWith(".EXE") || string2.indexOf(46) < 0;
    }

    private boolean isShellFile(String string) {
        String string2 = string.toUpperCase();
        return string2.endsWith(".CMD") || string2.endsWith(".BAT");
    }

    private String quoteString(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        return stringBuilder.append('\"').append(string).append('\"').toString();
    }

    private static int countLeadingBackslash(int n, CharSequence charSequence, int n2) {
        int n3;
        if (n == 0) {
            return 0;
        }
        for (n3 = n2 - 1; n3 >= 0 && charSequence.charAt(n3) == '\\'; --n3) {
        }
        return n2 - 1 - n3;
    }

    private ProcessImpl(String[] stringArray, String string, String string2, final long[] lArray, boolean bl) throws IOException {
        String string3;
        boolean bl2;
        SecurityManager securityManager = System.getSecurityManager();
        String string4 = GetPropertyAction.privilegedGetProperty("jdk.lang.Process.allowAmbiguousCommands");
        String string5 = string4 != null ? string4 : (securityManager == null ? "true" : "false");
        boolean bl3 = bl2 = !"false".equalsIgnoreCase(string5);
        if (bl2 && securityManager == null) {
            String string6 = new File(stringArray[0]).getPath();
            if (ProcessImpl.needsEscaping(3, string6)) {
                string6 = this.quoteString(string6);
            }
            string3 = ProcessImpl.createCommandLine(3, string6, stringArray);
        } else {
            boolean bl4;
            String string7;
            block6: {
                try {
                    string7 = ProcessImpl.getExecutablePath(stringArray[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string8 : stringArray) {
                        stringBuilder.append(string8).append(' ');
                    }
                    stringArray = ProcessImpl.getTokensFromCommand(stringBuilder.toString());
                    string7 = ProcessImpl.getExecutablePath(stringArray[0]);
                    if (securityManager == null) break block6;
                    securityManager.checkExec(string7);
                }
            }
            boolean bl5 = bl2 ? this.isShellFile(string7) : (bl4 = !this.isExe(string7));
            string3 = ProcessImpl.createCommandLine(bl4 ? 0 : (bl2 ? 1 : 2), this.quoteString(string7), stringArray);
        }
        this.handle = ProcessImpl.create(string3, string, string2, lArray, bl);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                FileDescriptor fileDescriptor;
                if (lArray[0] == -1L) {
                    ProcessImpl.this.stdin_stream = ProcessBuilder.NullOutputStream.INSTANCE;
                } else {
                    fileDescriptor = new FileDescriptor();
                    fdAccess.setHandle(fileDescriptor, lArray[0]);
                    ProcessImpl.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(fileDescriptor));
                }
                if (lArray[1] == -1L) {
                    ProcessImpl.this.stdout_stream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    fileDescriptor = new FileDescriptor();
                    fdAccess.setHandle(fileDescriptor, lArray[1]);
                    ProcessImpl.this.stdout_stream = new BufferedInputStream(new FileInputStream(fileDescriptor));
                }
                if (lArray[2] == -1L) {
                    ProcessImpl.this.stderr_stream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    fileDescriptor = new FileDescriptor();
                    fdAccess.setHandle(fileDescriptor, lArray[2]);
                    ProcessImpl.this.stderr_stream = new FileInputStream(fileDescriptor);
                }
                return null;
            }
        });
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    protected void finalize() {
        ProcessImpl.closeHandle(this.handle);
    }

    private static native int getStillActive();

    @Override
    public int exitValue() {
        int n = ProcessImpl.getExitCodeProcess(this.handle);
        if (n == STILL_ACTIVE) {
            throw new IllegalThreadStateException("process has not exited");
        }
        return n;
    }

    private static native int getExitCodeProcess(long var0);

    @Override
    public int waitFor() throws InterruptedException {
        ProcessImpl.waitForInterruptibly(this.handle);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.exitValue();
    }

    private static native void waitForInterruptibly(long var0);

    @Override
    public boolean waitFor(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        if (ProcessImpl.getExitCodeProcess(this.handle) != STILL_ACTIVE) {
            return true;
        }
        if (l <= 0L) {
            return false;
        }
        long l3 = System.nanoTime() + l2;
        do {
            long l4;
            if ((l4 = TimeUnit.NANOSECONDS.toMillis(l2 + 999999L)) < 0L) {
                l4 = Integer.MAX_VALUE;
            }
            ProcessImpl.waitForTimeoutInterruptibly(this.handle, l4);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (ProcessImpl.getExitCodeProcess(this.handle) == STILL_ACTIVE) continue;
            return true;
        } while ((l2 = l3 - System.nanoTime()) > 0L);
        return ProcessImpl.getExitCodeProcess(this.handle) != STILL_ACTIVE;
    }

    private static native void waitForTimeoutInterruptibly(long var0, long var2);

    @Override
    public void destroy() {
        ProcessImpl.terminateProcess(this.handle);
    }

    @Override
    public Process destroyForcibly() {
        this.destroy();
        return this;
    }

    private static native void terminateProcess(long var0);

    @Override
    public boolean isAlive() {
        return ProcessImpl.isProcessAlive(this.handle);
    }

    private static native boolean isProcessAlive(long var0);

    private static synchronized native long create(String var0, String var1, String var2, long[] var3, boolean var4) throws IOException;

    private static native long openForAtomicAppend(String var0) throws IOException;

    private static native boolean closeHandle(long var0);

    private static class LazyPattern {
        private static final Pattern PATTERN = Pattern.compile("[^\\s\"]+|\"[^\"]*\"");

        private LazyPattern() {
        }
    }
}

