/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.logging;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import si.nevensrok.common.logging.AbstractBackgroundAppender;
import si.nevensrok.common.logging.LogItem;

public class DatabaseAppender
extends AbstractBackgroundAppender {
    private Connection connection = null;
    private String driver;
    private String url;
    private String username;
    private String password;
    private String table;

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
        block3: {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Exception e) {
                if (!this.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        this.connection = null;
    }

    @Override
    public void logItem(LogItem logItem) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("insert into " + this.table + " (EventDate,ThreadName,Category,LogLevel,Message,Throwable,LocationClassName,LocationMethodName,LocationLineNumber,MachineIp4,MachineIp6,MachineHostname,MachineName,ProcessName) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            preparedStatement.setTimestamp(1, new Timestamp(logItem.getTimeStamp()));
            preparedStatement.setString(2, logItem.getThreadName());
            preparedStatement.setString(3, logItem.getCategory());
            preparedStatement.setString(4, logItem.getLevel());
            preparedStatement.setString(5, logItem.getMessage());
            preparedStatement.setString(6, logItem.getThrowable());
            preparedStatement.setString(7, logItem.getLocationClassName());
            preparedStatement.setString(8, logItem.getLocationMethodName());
            preparedStatement.setString(9, logItem.getLocationLineNumber());
            preparedStatement.setString(10, logItem.getMachineIp4());
            preparedStatement.setString(11, logItem.getMachineIp6());
            preparedStatement.setString(12, logItem.getMachineHostname());
            preparedStatement.setString(13, logItem.getMachineName());
            preparedStatement.setString(14, logItem.getProcessName());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (Exception e) {
            if (this.isDebug()) {
                e.printStackTrace();
            }
            this.disconnect();
        }
    }

    private Connection getConnection() {
        block4: {
            if (this.isClosed()) {
                return null;
            }
            if (this.connection == null) {
                try {
                    Class.forName(this.driver);
                    this.connection = DriverManager.getConnection(this.url, this.username, this.password);
                }
                catch (Exception e) {
                    if (!this.isDebug()) break block4;
                    e.printStackTrace();
                }
            }
        }
        return this.connection;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTable(String table) {
        this.table = table;
    }
}

