/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.network.udp.AbstractMessagesReceiver;

public class MulticastMessagesReceiver
extends AbstractMessagesReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MulticastMessagesReceiver.class);
    private Integer port;
    private String address;

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    DatagramSocket openSocket() throws IOException {
        MulticastSocket multicastSocket = this.getPort() == null || this.getPort() < 1 ? new MulticastSocket(0) : new MulticastSocket(this.getPort());
        multicastSocket.joinGroup(InetAddress.getByName(this.getAddress()));
        return multicastSocket;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Property 'address' is required");
        }
        LOGGER.debug("Listening for multicast on [{}]:{}", (Object)this.getAddress(), (Object)this.getPort());
        super.afterPropertiesSet();
    }

    @Override
    public void destroy() throws Exception {
        LOGGER.debug("Stopping listening from multicast on [{}]:{}", (Object)this.getAddress(), (Object)this.getPort());
        try {
            ((MulticastSocket)this.getSocket()).leaveGroup(InetAddress.getByName(this.getAddress()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.destroy();
    }
}

