/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.rules.rules2023.CompetitionRules2023;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.FightPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.NewazaPoints;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class PenaltyTracker
extends JPanel {
    private JLabel penalty = new JLabel("Pen.");
    private JPanel marksPanel = new JPanel();
    private JLabel[] marks = new JLabel[0];
    private CompetitorType competitorType;
    private FightPoints fightPoints;
    private NewazaPoints newazaPoints;
    private MatchData matchData;
    private TablaManager tablaManager;

    public PenaltyTracker(CompetitorType competitorType) {
        this.competitorType = competitorType;
        this.setLayout(null);
        this.add(this.penalty);
        this.add(this.marksPanel);
        this.setPenaltyMarkCount(6);
    }

    public void setFightPoints(FightPoints fightPoints) {
        this.fightPoints = fightPoints;
    }

    public void setNewazaPoints(NewazaPoints newazaPoints) {
        this.newazaPoints = newazaPoints;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public void redrawElements() {
        int width = this.getWidth();
        int height = this.getHeight();
        int penaltyWidth = (int)Math.floor((float)width * 0.25f);
        this.penalty.setLocation(0, 0);
        this.penalty.setSize(penaltyWidth, height);
        FontSizeUtil.refitFontSize(Constants.FONT, this.penalty);
        this.marksPanel.setLocation(penaltyWidth, 0);
        this.marksPanel.setSize(width - penaltyWidth, height);
        int maxPenalties = 0;
        int penalties = 0;
        CompetitionRules competitionRules = this.tablaManager.getCurrentCompetitionRules();
        if (this.matchData.getTableType() == TableType.FIGHT && this.fightPoints != null) {
            if (competitionRules != null) {
                maxPenalties = competitionRules.getFightMaxPenaltyPoints();
            }
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                if (this.fightPoints.getHansokumake1() == 1) {
                    penalties = maxPenalties;
                } else if (competitionRules != null) {
                    penalties = competitionRules instanceof CompetitionRules2023 ? this.fightPoints.getShido1() * competitionRules.getShidoWazariValue() + this.fightPoints.getChui1() * competitionRules.getChuiWazariValue() : this.fightPoints.getChui1() * competitionRules.getChuiWazariValue();
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                if (this.fightPoints.getHansokumake2() == 1) {
                    penalties = maxPenalties;
                } else if (competitionRules != null) {
                    penalties = competitionRules instanceof CompetitionRules2023 ? this.fightPoints.getShido2() * competitionRules.getShidoWazariValue() + this.fightPoints.getChui2() * competitionRules.getChuiWazariValue() : this.fightPoints.getChui2() * competitionRules.getChuiWazariValue();
                }
            }
        } else if (this.matchData.getTableType() == TableType.NEWAZA && this.newazaPoints != null) {
            AgeCategoryOption ageCategoryOption = new AgeCategoryOption();
            ageCategoryOption.setNewazaPenaltyHansokumake(Integer.valueOf(this.matchData.getNewazaPenaltyHansokumake()));
            if (competitionRules != null) {
                maxPenalties = competitionRules.getNewazaMaxPenaltyPoints(ageCategoryOption);
            }
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                if (this.newazaPoints.getHansokumake1() == 1) {
                    penalties = maxPenalties;
                } else if (competitionRules != null) {
                    penalties = this.newazaPoints.getPenalty1();
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                if (this.newazaPoints.getHansokumake2() == 1) {
                    penalties = maxPenalties;
                } else if (competitionRules != null) {
                    penalties = this.newazaPoints.getPenalty2();
                }
            }
        }
        if (this.marks.length != maxPenalties) {
            this.setPenaltyMarkCount(maxPenalties);
        }
        this.setPenaltyMarkFilled(penalties);
        for (JLabel mark : this.marks) {
            FontSizeUtil.refitFontSize(Constants.FONT, mark);
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.penalty != null) {
            this.penalty.setBackground(bg);
        }
        if (this.marksPanel != null) {
            this.marksPanel.setBackground(bg);
        }
        if (this.marks != null) {
            for (JLabel mark : this.marks) {
                mark.setBackground(bg);
            }
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.penalty != null) {
            this.penalty.setForeground(fg);
        }
        if (this.marksPanel != null) {
            this.marksPanel.setForeground(fg);
        }
    }

    private void setPenaltyMarkCount(int count) {
        for (JLabel mark : this.marks) {
            this.marksPanel.remove(mark);
        }
        this.marks = new JLabel[count];
        this.marksPanel.setLayout(new GridLayout(1, this.marks.length));
        for (int i = 0; i < this.marks.length; ++i) {
            this.marks[i] = new JLabel("\u25cf");
            this.marks[i].setForeground(Constants.PENALTY_MARK_EMPTY_COLOR);
            this.marks[i].setHorizontalAlignment(0);
            this.marksPanel.add(this.marks[i]);
        }
    }

    private void setPenaltyMarkFilled(int count) {
        if (count < 1) {
            for (JLabel mark : this.marks) {
                mark.setForeground(Constants.PENALTY_MARK_EMPTY_COLOR);
            }
        } else if (count >= this.marks.length) {
            for (JLabel mark : this.marks) {
                mark.setForeground(Constants.PENALTY_MARK_FILL_COLOR);
            }
        } else {
            for (int i = 0; i < this.marks.length; ++i) {
                if (i < count) {
                    this.marks[i].setForeground(Constants.PENALTY_MARK_FILL_COLOR);
                    continue;
                }
                this.marks[i].setForeground(Constants.PENALTY_MARK_EMPTY_COLOR);
            }
        }
    }
}

