/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JPanel;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.horizontal.DuoFieldSelector;
import si.nevensrok.jtekma.tabla.gui.horizontal.DuoPointsRow;

public class DuoPointsPanel
extends JPanel
implements si.nevensrok.jtekma.tabla.gui.DuoPointsPanel {
    private DuoPointsRow[] pointRows = new DuoPointsRow[5];

    public DuoPointsPanel(CompetitorType competitorType) {
        this.setLayout(new GridLayout(this.pointRows.length, 1));
        for (int i = 0; i < this.pointRows.length; ++i) {
            this.pointRows[i] = new DuoPointsRow(competitorType, i + 1);
            this.add(this.pointRows[i]);
        }
    }

    public void setDuoPoints(DuoPoints duoPoints) {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.setDuoPoints(duoPoints);
        }
    }

    public void setTablaManager(TablaManager tablaManager) {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.setTablaManager(tablaManager);
        }
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.setWindowKeyListener(windowKeyListener);
        }
    }

    public void setDuoFieldSelector(DuoFieldSelector duoFieldSelector) {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.setDuoFieldSelector(duoFieldSelector);
        }
    }

    public void redrawElements() {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.redrawElements();
        }
    }

    @Override
    public void resetPoints() {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.resetPoints();
        }
    }

    @Override
    public void selectFirstField() {
        this.selectField(1);
    }

    @Override
    public void selectPrevField() {
    }

    @Override
    public void selectNextField() {
    }

    @Override
    public void recalculateRoundPoints() {
        for (DuoPointsRow pointsRow : this.pointRows) {
            pointsRow.recalculateRoundPoints();
        }
    }

    public void selectField(int index) {
        int round = (index - 1) / 5;
        this.pointRows[round].selectField((index - 1) % 5 + 1);
    }

    public int getSelectedField() {
        for (int i = 0; i < this.pointRows.length; ++i) {
            int n = this.pointRows[i].getSelectedField();
            if (n <= 0) continue;
            return i * this.pointRows.length + n;
        }
        return 0;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.pointRows != null) {
            for (DuoPointsRow pointsRow : this.pointRows) {
                if (pointsRow == null) continue;
                pointsRow.setBackground(bg);
            }
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.pointRows != null) {
            for (DuoPointsRow pointsRow : this.pointRows) {
                if (pointsRow == null) continue;
                pointsRow.setForeground(fg);
            }
        }
    }
}

