/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import java.awt.EventQueue;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.common.threads.ThreadUtil;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.common.FightPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.NewazaPoints;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.TextSource;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.horizontal.DuoFieldSelector;
import si.nevensrok.jtekma.tabla.gui.horizontal.DuoPointsPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.FightPointsPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.NamePanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.NewazaPointsPanel;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class CompetitorPanel
extends JPanel {
    private NamePanel namePanel = new NamePanel();
    private FightPointsPanel fightPointsPanel;
    private DuoPointsPanel duoPointsPanel;
    private NewazaPointsPanel newazaPointsPanel;
    private JLabel pointLabel = new JLabel("0");
    private MatchData matchData;

    public CompetitorPanel(CompetitorType competitorType) {
        this.fightPointsPanel = new FightPointsPanel(competitorType);
        this.duoPointsPanel = new DuoPointsPanel(competitorType);
        this.newazaPointsPanel = new NewazaPointsPanel(competitorType);
        this.setLayout(null);
        this.add(this.namePanel);
        this.add(this.fightPointsPanel);
        this.add(this.duoPointsPanel);
        this.add(this.newazaPointsPanel);
        this.add(this.pointLabel);
        this.pointLabel.setHorizontalAlignment(0);
        this.pointLabel.setFont(Constants.FONT);
    }

    public void setFightPoints(FightPoints fightPoints) {
        this.fightPointsPanel.setFightPoints(fightPoints);
    }

    public void setDuoPoints(DuoPoints duoPoints) {
        this.duoPointsPanel.setDuoPoints(duoPoints);
    }

    public void setNewazaPoints(NewazaPoints newazaPoints) {
        this.newazaPointsPanel.setNewazaPoints(newazaPoints);
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
        this.fightPointsPanel.setMatchData(matchData);
        this.newazaPointsPanel.setMatchData(matchData);
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.fightPointsPanel.setTablaManager(tablaManager);
        this.newazaPointsPanel.setTablaManager(tablaManager);
        this.duoPointsPanel.setTablaManager(tablaManager);
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        this.duoPointsPanel.setWindowKeyListener(windowKeyListener);
    }

    public void setDuoFieldSelector(DuoFieldSelector duoFieldSelector) {
        this.duoPointsPanel.setDuoFieldSelector(duoFieldSelector);
    }

    public void setTextSource(TextSource textSource) {
        this.fightPointsPanel.setTextSource(textSource);
        this.newazaPointsPanel.setTextSource(textSource);
    }

    public void setCompetitorName(String name) {
        this.namePanel.setCompetitorName(name);
    }

    public void setCompetitorClub(String club) {
        this.namePanel.setCompetitorClub(club);
    }

    public void setPoints(final float points) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CompetitorPanel.this.matchData.getTableType() == TableType.FIGHT || CompetitorPanel.this.matchData.getTableType() == TableType.NEWAZA) {
                    CompetitorPanel.this.pointLabel.setText(Constants.FIGHT_POINTS_FORMAT.format(points));
                } else if (CompetitorPanel.this.matchData.getTableType() == TableType.DUO) {
                    CompetitorPanel.this.pointLabel.setText(Constants.DUO_POINTS_FORMAT.format(points));
                } else {
                    CompetitorPanel.this.pointLabel.setText("");
                }
                FontSizeUtil.refitFontSize(Constants.FONT, CompetitorPanel.this.pointLabel);
            }
        });
    }

    public void resetDuoPoints() {
        this.duoPointsPanel.resetPoints();
    }

    public void recalculateDuoPoints() {
        this.duoPointsPanel.recalculateRoundPoints();
    }

    public void selectFirstDuoField() {
        this.duoPointsPanel.selectFirstField();
    }

    public void selectDuoField(int index) {
        this.duoPointsPanel.selectField(index);
    }

    public int getSelectedDuoField() {
        return this.duoPointsPanel.getSelectedField();
    }

    public void redrawElements() {
        int width = this.getWidth();
        int height = this.getHeight();
        int namePanelWidth = (int)Math.floor((float)width * 0.6f);
        this.namePanel.setLocation(0, 0);
        this.namePanel.setSize(namePanelWidth, height);
        int pointsPanelWidth = (int)Math.floor((float)width * 0.2f);
        this.pointLabel.setLocation(namePanelWidth + pointsPanelWidth, 0);
        this.pointLabel.setSize(width - namePanelWidth - pointsPanelWidth, height);
        FontSizeUtil.refitFontSize(Constants.FONT, this.pointLabel);
        if (this.matchData.getTableType() == TableType.FIGHT) {
            this.fightPointsPanel.setLocation(namePanelWidth, 0);
            this.fightPointsPanel.setSize(pointsPanelWidth, height);
            this.newazaPointsPanel.setLocation(0, 0);
            this.newazaPointsPanel.setSize(0, 0);
            this.duoPointsPanel.setLocation(0, 0);
            this.duoPointsPanel.setSize(0, 0);
        } else if (this.matchData.getTableType() == TableType.DUO) {
            this.duoPointsPanel.setLocation(namePanelWidth, 0);
            this.duoPointsPanel.setSize(pointsPanelWidth, height);
            this.fightPointsPanel.setLocation(0, 0);
            this.fightPointsPanel.setSize(0, 0);
            this.newazaPointsPanel.setLocation(0, 0);
            this.newazaPointsPanel.setSize(0, 0);
        } else if (this.matchData.getTableType() == TableType.NEWAZA) {
            this.newazaPointsPanel.setLocation(namePanelWidth, 0);
            this.newazaPointsPanel.setSize(pointsPanelWidth, height);
            this.fightPointsPanel.setLocation(0, 0);
            this.fightPointsPanel.setSize(0, 0);
            this.duoPointsPanel.setLocation(0, 0);
            this.duoPointsPanel.setSize(0, 0);
        }
        this.namePanel.redrawElements();
        this.fightPointsPanel.redrawElements();
        this.duoPointsPanel.redrawElements();
        this.newazaPointsPanel.redrawElements();
        ThreadUtil.runInBackground((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CompetitorPanel.this.namePanel.redrawElements();
                        CompetitorPanel.this.fightPointsPanel.redrawElements();
                        CompetitorPanel.this.duoPointsPanel.redrawElements();
                        CompetitorPanel.this.newazaPointsPanel.redrawElements();
                        CompetitorPanel.this.repaint();
                    }
                });
            }
        });
        this.repaint();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.namePanel != null) {
            this.namePanel.setBackground(bg);
        }
        if (this.fightPointsPanel != null) {
            this.fightPointsPanel.setBackground(bg);
        }
        if (this.duoPointsPanel != null) {
            this.duoPointsPanel.setBackground(bg);
        }
        if (this.newazaPointsPanel != null) {
            this.newazaPointsPanel.setBackground(bg);
        }
        if (this.pointLabel != null) {
            this.pointLabel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.namePanel != null) {
            this.namePanel.setForeground(fg);
        }
        if (this.fightPointsPanel != null) {
            this.fightPointsPanel.setForeground(fg);
        }
        if (this.duoPointsPanel != null) {
            this.duoPointsPanel.setForeground(fg);
        }
        if (this.newazaPointsPanel != null) {
            this.newazaPointsPanel.setForeground(fg);
        }
        if (this.pointLabel != null) {
            this.pointLabel.setForeground(fg);
        }
    }
}

