/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.duo;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.fw.TablaManager;

public class DuoPointsDocument
extends PlainDocument {
    private CompetitorType competitorType;
    private int round;
    private int judge;
    private DuoPoints duoPoints;
    private TablaManager tablaManager;

    public DuoPointsDocument(CompetitorType competitorType, int round, int judge, DuoPoints duoPoints, TablaManager tablaManager) {
        this.competitorType = competitorType;
        this.round = round;
        this.judge = judge;
        this.duoPoints = duoPoints;
        this.tablaManager = tablaManager;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        try {
            StringBuffer buffer = new StringBuffer(this.getText(0, this.getLength()));
            buffer.insert(offs, str);
            float newNum = Float.parseFloat(buffer.toString());
            if (newNum >= 0.0f && newNum <= 10.0f) {
                super.insertString(offs, str, a);
                this.updatePoints();
                this.tablaManager.recalculatePoints();
            } else if (newNum > 10.0f && newNum <= 99.0f) {
                str = str.length() == 1 ? "." + str.substring(0, 1) : "." + str.substring(1, 2);
                super.insertString(offs, str, a);
                this.updatePoints();
                this.tablaManager.recalculatePoints();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        try {
            StringBuffer buffer = new StringBuffer(this.getText(0, this.getLength()));
            buffer.delete(offs, offs + len);
            if (buffer.length() == 0) {
                super.remove(offs, len);
                if (this.competitorType == CompetitorType.COMPETITOR1) {
                    this.duoPoints.setPoints1(this.round, this.judge, 0.0f);
                } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                    this.duoPoints.setPoints2(this.round, this.judge, 0.0f);
                }
                this.tablaManager.recalculatePoints();
            } else {
                float newNum = Float.parseFloat(buffer.toString());
                if (newNum >= 0.0f && newNum <= 10.0f) {
                    super.remove(offs, len);
                    this.updatePoints();
                    this.tablaManager.recalculatePoints();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePoints() throws NumberFormatException, BadLocationException {
        if (this.competitorType == CompetitorType.COMPETITOR1) {
            this.duoPoints.setPoints1(this.round, this.judge, Float.parseFloat(super.getText(0, super.getLength())));
        } else if (this.competitorType == CompetitorType.COMPETITOR2) {
            this.duoPoints.setPoints2(this.round, this.judge, Float.parseFloat(super.getText(0, super.getLength())));
        }
    }
}

