/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;

public final class ECKeyFactory
extends KeyFactorySpi {
    private static KeyFactory instance;

    private static KeyFactory getInstance() {
        if (instance == null) {
            try {
                instance = KeyFactory.getInstance("EC", "SunEC");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new RuntimeException(noSuchProviderException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
        }
        return instance;
    }

    public static ECKey toECKey(Key key) throws InvalidKeyException {
        if (key instanceof ECKey) {
            ECKey eCKey = (ECKey)((Object)key);
            ECKeyFactory.checkKey(eCKey);
            return eCKey;
        }
        return (ECKey)((Object)ECKeyFactory.getInstance().translateKey(key));
    }

    private static void checkKey(ECKey eCKey) throws InvalidKeyException {
        String string;
        if (eCKey instanceof ECPublicKey) {
            if (eCKey instanceof ECPublicKeyImpl) {
                return;
            }
        } else if (eCKey instanceof ECPrivateKey) {
            if (eCKey instanceof ECPrivateKeyImpl) {
                return;
            }
        } else {
            throw new InvalidKeyException("Neither a public nor a private key");
        }
        if (!(string = ((Key)((Object)eCKey)).getAlgorithm()).equals("EC")) {
            throw new InvalidKeyException("Not an EC key: " + string);
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        String string = key.getAlgorithm();
        if (!string.equals("EC")) {
            throw new InvalidKeyException("Not an EC key: " + string);
        }
        if (key instanceof PublicKey) {
            return this.implTranslatePublicKey((PublicKey)key);
        }
        if (key instanceof PrivateKey) {
            return this.implTranslatePrivateKey((PrivateKey)key);
        }
        throw new InvalidKeyException("Neither a public nor a private key");
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.implGeneratePublic(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeySpecException(generalSecurityException);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.implGeneratePrivate(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeySpecException(generalSecurityException);
        }
    }

    private PublicKey implTranslatePublicKey(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof ECPublicKey) {
            if (publicKey instanceof ECPublicKeyImpl) {
                return publicKey;
            }
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            return new ECPublicKeyImpl(eCPublicKey.getW(), eCPublicKey.getParams());
        }
        if ("X.509".equals(publicKey.getFormat())) {
            byte[] byArray = publicKey.getEncoded();
            return new ECPublicKeyImpl(byArray);
        }
        throw new InvalidKeyException("Public keys must be instance of ECPublicKey or have X.509 encoding");
    }

    private PrivateKey implTranslatePrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof ECPrivateKey) {
            if (privateKey instanceof ECPrivateKeyImpl) {
                return privateKey;
            }
            ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
            return new ECPrivateKeyImpl(eCPrivateKey.getS(), eCPrivateKey.getParams());
        }
        if ("PKCS#8".equals(privateKey.getFormat())) {
            return new ECPrivateKeyImpl(privateKey.getEncoded());
        }
        throw new InvalidKeyException("Private keys must be instance of ECPrivateKey or have PKCS#8 encoding");
    }

    private PublicKey implGeneratePublic(KeySpec keySpec) throws GeneralSecurityException {
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec;
            return new ECPublicKeyImpl(x509EncodedKeySpec.getEncoded());
        }
        if (keySpec instanceof ECPublicKeySpec) {
            ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)keySpec;
            return new ECPublicKeyImpl(eCPublicKeySpec.getW(), eCPublicKeySpec.getParams());
        }
        throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
    }

    private PrivateKey implGeneratePrivate(KeySpec keySpec) throws GeneralSecurityException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
            return new ECPrivateKeyImpl(pKCS8EncodedKeySpec.getEncoded());
        }
        if (keySpec instanceof ECPrivateKeySpec) {
            ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)keySpec;
            return new ECPrivateKeyImpl(eCPrivateKeySpec.getS(), eCPrivateKeySpec.getParams());
        }
        throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        try {
            key = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException);
        }
        if (key instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)key;
            if (clazz.isAssignableFrom(ECPublicKeySpec.class)) {
                return (T)((KeySpec)clazz.cast(new ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams())));
            }
            if (clazz.isAssignableFrom(X509EncodedKeySpec.class)) {
                return (T)((KeySpec)clazz.cast(new X509EncodedKeySpec(key.getEncoded())));
            }
            throw new InvalidKeySpecException("KeySpec must be ECPublicKeySpec or X509EncodedKeySpec for EC public keys");
        }
        if (key instanceof ECPrivateKey) {
            if (clazz.isAssignableFrom(PKCS8EncodedKeySpec.class)) {
                return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
            }
            if (clazz.isAssignableFrom(ECPrivateKeySpec.class)) {
                ECPrivateKey eCPrivateKey = (ECPrivateKey)key;
                return (T)((KeySpec)clazz.cast(new ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams())));
            }
            throw new InvalidKeySpecException("KeySpec must be ECPrivateKeySpec or PKCS8EncodedKeySpec for EC private keys");
        }
        throw new InvalidKeySpecException("Neither public nor private key");
    }
}

