/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpRedirectFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRedirectFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String uri = request.getRequestURI();
            String filterRegex = this.getFilterConfig().getInitParameter("filter");
            String destination = this.getFilterConfig().getInitParameter("destination");
            if (!request.getContextPath().isEmpty()) {
                destination = request.getContextPath() + destination;
            }
            LOGGER.trace("Checking redirect filter for {} against regex {} ", (Object)uri, (Object)filterRegex);
            if (filterRegex == null || uri.matches(filterRegex)) {
                LOGGER.trace("Redirecting {} to {}", (Object)uri, (Object)destination);
                response.sendRedirect(destination);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing filter", (Throwable)e);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

