/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.security.impl;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import si.nevensrok.common.web.security.UserData;
import si.nevensrok.common.web.security.UserDatabase;
import si.nevensrok.common.web.security.impl.LoginDetails;
import si.nevensrok.common.web.security.impl.UserAuthentication;

public class UserAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAuthenticationProvider.class);
    private UserDatabase userDatabase;

    public void setUserDatabase(UserDatabase userDatabase) {
        this.userDatabase = userDatabase;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        LOGGER.debug("Checking authorization [{}]", (Object)authentication);
        if (!authentication.isAuthenticated()) {
            if (authentication instanceof UserAuthentication) {
                try {
                    LOGGER.debug("Authenticating via login UserAuthentication");
                    UserAuthentication userAuthentication = (UserAuthentication)authentication;
                    String username = userAuthentication.getPrincipal();
                    if (username == null) {
                        LOGGER.debug("Username is null");
                        return null;
                    }
                    UserData userData = this.userDatabase.getUserByUsername(username);
                    if (userData == null) {
                        LOGGER.debug("User data not found for username [{}]", (Object)username);
                        return null;
                    }
                    userAuthentication.setAuthenticated(true);
                    userAuthentication.setUserData(userData);
                    userAuthentication.setDetails(new LoginDetails());
                    List<GrantedAuthority> grantedAuthorities = this.userDatabase.getGrantedAuthoritys(userData);
                    userAuthentication.getAuthorities().addAll(grantedAuthorities);
                    return userAuthentication;
                }
                catch (Exception e) {
                    LOGGER.error("Error while authenticating", (Throwable)e);
                }
            } else if (authentication instanceof UsernamePasswordAuthenticationToken) {
                try {
                    if (authentication.getPrincipal() != null && authentication.getCredentials() != null) {
                        LOGGER.debug("Authenticating via login service");
                        String username = authentication.getPrincipal().toString();
                        String password = authentication.getCredentials().toString();
                        UserData userData = this.userDatabase.getUserByUsernameAndPassword(username, password);
                        if (userData == null) {
                            LOGGER.debug("User data not found for username [{}] and password [****]", (Object)username);
                            return null;
                        }
                        UserAuthentication userAuthentication = new UserAuthentication();
                        userAuthentication.setAuthenticated(true);
                        userAuthentication.setUsername(userData.getUsername());
                        userAuthentication.setUserData(userData);
                        userAuthentication.setDetails(new LoginDetails());
                        List<GrantedAuthority> grantedAuthorities = this.userDatabase.getGrantedAuthoritys(userData);
                        userAuthentication.getAuthorities().addAll(grantedAuthorities);
                        return userAuthentication;
                    }
                    LOGGER.debug("Username or password is null");
                    return null;
                }
                catch (Exception e) {
                    LOGGER.debug("Error authenticating", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        return authentication;
    }

    public boolean supports(Class<?> authentication) {
        LOGGER.debug("Checking support for authentication [{}]", authentication);
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class) || authentication.isAssignableFrom(UserAuthentication.class);
    }
}

