/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.lock;

import java.util.HashMap;
import java.util.Map;
import si.nevensrok.common.utils.ObjectUtil;

public class LockContext {
    private static final ThreadLocal<Map<String, Integer>> LOCK_COUNTER = new ThreadLocal();
    private static final ThreadLocal<Map<String, Map<String, Object>>> CONTEXT = new ThreadLocal();

    public static <T> T getContextData(String name, String key) {
        Map<String, Object> context;
        Map<String, Map<String, Object>> contextData = CONTEXT.get();
        if (contextData == null) {
            contextData = new HashMap<String, Map<String, Object>>();
            CONTEXT.set(contextData);
        }
        if ((context = contextData.get(name)) == null) {
            context = new HashMap<String, Object>();
            contextData.put(name, context);
        }
        return (T)context.get(key);
    }

    public static void setContextData(String name, String key, Object value) {
        Map<String, Object> context;
        Map<String, Map<String, Object>> contextData = CONTEXT.get();
        if (contextData == null) {
            contextData = new HashMap<String, Map<String, Object>>();
            CONTEXT.set(contextData);
        }
        if ((context = contextData.get(name)) == null) {
            context = new HashMap<String, Object>();
            contextData.put(name, context);
        }
        context.put(key, value);
    }

    public static void removeContextData(String name, String key) {
        Map<String, Object> context;
        Map<String, Map<String, Object>> contextData = CONTEXT.get();
        if (contextData == null) {
            contextData = new HashMap<String, Map<String, Object>>();
            CONTEXT.set(contextData);
        }
        if ((context = contextData.get(name)) == null) {
            context = new HashMap<String, Object>();
            contextData.put(name, context);
        }
        context.remove(key);
    }

    private static Integer getLockCounter(String name) {
        Map<String, Integer> lockCounters = LOCK_COUNTER.get();
        if (lockCounters == null) {
            lockCounters = new HashMap<String, Integer>();
            LOCK_COUNTER.set(lockCounters);
        }
        return (Integer)ObjectUtil.ifNull((Object)lockCounters.get(name), (Object)0);
    }

    private static void setLockCounter(String name, int value) {
        Map<String, Integer> lockCounters = LOCK_COUNTER.get();
        if (lockCounters == null) {
            lockCounters = new HashMap<String, Integer>();
            LOCK_COUNTER.set(lockCounters);
        }
        lockCounters.put(name, value);
    }

    private static void removeLockCounter(String name) {
        Map<String, Integer> lockCounters = LOCK_COUNTER.get();
        if (lockCounters != null) {
            lockCounters.remove(name);
        }
    }

    public static boolean initOrAddLock(String name) {
        int n = LockContext.getLockCounter(name);
        if (n > 1) {
            LockContext.setLockCounter(name, ++n);
            return true;
        }
        return false;
    }

    public static void addLock(String name) {
        int n = LockContext.getLockCounter(name) + 1;
        LockContext.setLockCounter(name, n);
    }

    public static boolean removeLock(String name) {
        int n = LockContext.getLockCounter(name) - 1;
        if (n <= 0) {
            LockContext.removeLockCounter(name);
            return true;
        }
        LockContext.setLockCounter(name, n);
        return false;
    }
}

