/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.reports;

import java.io.IOException;
import java.io.OutputStream;
import java.text.Normalizer;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.reports.DocumentType;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.reports.TreeReportModel;

@Controller
@RequestMapping(value={"/reports/results-for-club"})
public class ResultsForClubReportController
extends CoreController {
    @RequestMapping(method={RequestMethod.GET})
    public String index(HttpServletRequest request, Model model, @ModelAttribute(value="resultsForClub") TreeReportModel resultsForClub) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        model.addAttribute("resultsForClubActive", (Object)true);
        LinkedHashMap<String, String> documentTypes = new LinkedHashMap<String, String>();
        documentTypes.put(DocumentType.PDF.name(), this.getLanguageText(locale, "report.documentType.PDF"));
        documentTypes.put(DocumentType.ODT.name(), this.getLanguageText(locale, "report.documentType.ODT"));
        model.addAttribute("documentTypes", documentTypes);
        LinkedHashMap<String, String> locales = new LinkedHashMap<String, String>();
        locales.put("en", this.getLanguageText(locale, "locale.english"));
        locales.put("sl", this.getLanguageText(locale, "locale.slovenian"));
        model.addAttribute("locales", locales);
        resultsForClub.setLocale(RequestContextUtils.getLocale((HttpServletRequest)request).getLanguage());
        Club clubExample = new Club();
        clubExample.setStatus(Club.Status.ACTIVE);
        SimpleDataFilter clubDataFilter = new SimpleDataFilter();
        clubDataFilter.setFilter((Filter)new ExampleFilter((Object)clubExample));
        clubDataFilter.setSort(new Sort());
        clubDataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        PageDataResult clubDataResult = this.getManagersList().getClubManager().find(this.getUserData().getCompetition(), (DataFilter)clubDataFilter);
        LinkedHashMap<Long, String> clubs = new LinkedHashMap<Long, String>();
        for (Club club : clubDataResult.getData()) {
            clubs.put(club.getClubId(), club.getName());
        }
        model.addAttribute("clubs", clubs);
        return "reports/results-for-club";
    }

    @RequestMapping(method={RequestMethod.POST})
    public void download(HttpServletRequest request, HttpServletResponse response, @ModelAttribute(value="resultsForClub") TreeReportModel resultsForClub) throws IOException {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Competition competition = this.getManagersList().getCompetitionManager().getById(this.getUserData().getCompetition().getCompetitionId());
        if (competition == null) {
            return;
        }
        Club club = null;
        if (resultsForClub.getForClub() != null && resultsForClub.getForClub() > 0L) {
            club = this.getManagersList().getClubManager().getById(resultsForClub.getForClub());
        }
        if (club == null) {
            return;
        }
        String fileName = this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "report.filename.resultsForClub");
        fileName = fileName + "-" + club.getName();
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFD).replaceAll("[^\\p{Alnum}\\x20\\x2B\\x2D\\x2E\\x5F]", "");
        fileName = fileName.replace(' ', '_');
        if (resultsForClub.getDocumentType() == DocumentType.PDF) {
            response.setContentType("application/pdf");
            fileName = fileName + ".pdf";
        } else if (resultsForClub.getDocumentType() == DocumentType.ODT) {
            response.setContentType("application/vnd.oasis.opendocument.text");
            fileName = fileName + ".odt";
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        if (resultsForClub.getLocale() != null) {
            locale = new Locale(resultsForClub.getLocale());
        }
        ServletOutputStream outputStream = response.getOutputStream();
        this.getManagersList().getReportGenerator().generateResultsForClub(resultsForClub.getDocumentType(), locale, (OutputStream)outputStream, competition, club);
        outputStream.close();
    }
}

