/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryMatchCount;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.club.ClubCompetitorPoints;
import si.nevensrok.jtekma.common.club.ClubPlacing;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.server.web.common.CategoryStatus;
import si.nevensrok.jtekma.server.web.controllers.CoreController;

@Controller
@RequestMapping(value={"/"})
public class IndexController
extends CoreController
implements InitializingBean {
    private static final Float MATCH_DURATION_KOEFICIENT = Float.valueOf(1.6666666f);
    private LogoutHandler logoutHandler;
    private List<String> messages = new LinkedList<String>();

    public void setLogoutHandler(LogoutHandler logoutHandler) {
        this.logoutHandler = logoutHandler;
    }

    public void afterPropertiesSet() throws Exception {
        Properties properties = new Properties();
        properties.load(this.getApplicationContext().getResource("classpath:/si/nevensrok/jtekma/server/web/translations/messages.properties").getInputStream());
        for (Object key : properties.keySet()) {
            this.messages.add(key.toString());
        }
    }

    @RequestMapping
    public String index(HttpServletRequest request, Model model) {
        if (this.getUserData().getCompetition() == null) {
            return "redirect:/select-competition";
        }
        Competition competition = this.getManagersList().getCompetitionManager().getById(this.getUserData().getCompetition().getCompetitionId());
        if (competition == null) {
            return "redirect:/select-competition";
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("Competition rules not found");
        }
        Category categoryExample = new Category();
        categoryExample.setStatus(Category.Status.ACTIVE);
        SimpleDataFilter categoryDataFilter = new SimpleDataFilter();
        categoryDataFilter.setFilter((Filter)new ExampleFilter((Object)categoryExample));
        categoryDataFilter.setItemLimit(Integer.valueOf(1000));
        categoryDataFilter.setSort(new Sort());
        categoryDataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        List categories = this.getManagersList().getCategoryManager().find(competition, (DataFilter)categoryDataFilter).getData();
        this.addCompetitionStatus(competition, categories, model);
        this.addClubPlacings(competition, categories, competitionRules, model);
        return "index";
    }

    private void addCompetitionStatus(Competition competition, List<Category> categories, Model model) {
        LinkedList<CategoryStatus> categoryStatuses = new LinkedList<CategoryStatus>();
        Map matchCount = this.getManagersList().getCategoryManager().getCategoryMatchCount(new HashSet<Category>(categories));
        int matchFinished = 0;
        int matchNotFinished = 0;
        int timeRequired = 0;
        for (Category category : categories) {
            AgeCategoryOption ageCategoryOption;
            CategoryStatus categoryStatus = new CategoryStatus();
            categoryStatuses.add(categoryStatus);
            categoryStatus.setCategory(category);
            categoryStatus.setFinished(((CategoryMatchCount)matchCount.get(category)).getFinishedMatches());
            categoryStatus.setNotFinished(((CategoryMatchCount)matchCount.get(category)).getNeededMatches());
            matchFinished += ((CategoryMatchCount)matchCount.get(category)).getFinishedMatches().intValue();
            matchNotFinished += ((CategoryMatchCount)matchCount.get(category)).getNeededMatches().intValue();
            categoryStatus.setTotal(categoryStatus.getFinished() + categoryStatus.getNotFinished());
            categoryStatus.setFinishProcent(Math.round((float)categoryStatus.getFinished().intValue() / (float)categoryStatus.getTotal().intValue() * 100.0f));
            int matchDuration = 180;
            if (category instanceof FightingCategory) {
                FightingCategory fightingCategory = (FightingCategory)category;
                ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getForCategory(fightingCategory);
                if (ageCategoryOption != null) {
                    matchDuration = ageCategoryOption.getFightTime();
                }
            } else if (category instanceof NewazaCategory) {
                NewazaCategory newazaCategory = (NewazaCategory)category;
                ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getForCategory(newazaCategory);
                if (ageCategoryOption != null) {
                    matchDuration = ageCategoryOption.getFightTime();
                }
            }
            timeRequired += Math.round((float)((CategoryMatchCount)matchCount.get(category)).getNeededMatches().intValue() * (float)matchDuration * MATCH_DURATION_KOEFICIENT.floatValue());
        }
        model.addAttribute("totalTimeRequired", (Object)timeRequired);
        Integer tatamiCount = this.getManagersList().getTatamiManager().getTatamiCount(competition);
        if (tatamiCount != null && tatamiCount > 0) {
            timeRequired /= tatamiCount.intValue();
        }
        model.addAttribute("categoryStatuses", categoryStatuses);
        int matchTotal = matchFinished + matchNotFinished;
        model.addAttribute("matchCountFinished", (Object)matchFinished);
        model.addAttribute("matchCountNotFinished", (Object)matchNotFinished);
        model.addAttribute("matchCountTotal", (Object)matchTotal);
        model.addAttribute("matchFinishProcent", (Object)Math.round((float)matchFinished / (float)matchTotal * 100.0f));
        model.addAttribute("timeRequired", (Object)timeRequired);
        Calendar competitionFinishedAt = Calendar.getInstance();
        competitionFinishedAt.add(13, timeRequired);
        model.addAttribute("competitionFinishedAt", (Object)competitionFinishedAt.getTime());
    }

    private void addClubPlacings(Competition competition, List<Category> categories, CompetitionRules competitionRules, Model model) {
        Map competitionSettings = this.getManagersList().getCompetitionManager().getCompetitionSettings(competition);
        HashMap<Integer, Integer> pointsForPlace = new HashMap<Integer, Integer>();
        for (int i = 1; i <= 7; ++i) {
            if (competitionSettings.get("clubPlacing.points." + i) == null) continue;
            pointsForPlace.put(i, ((Long)competitionSettings.get("clubPlacing.points." + i)).intValue());
        }
        boolean includeOneCompetitor = competitionSettings.get("clubPlacing.includeOneCompetitor") == null ? true : (Boolean)competitionSettings.get("clubPlacing.includeOneCompetitor");
        boolean includeSameClub = competitionSettings.get("clubPlacing.includeSameClub") == null ? true : (Boolean)competitionSettings.get("clubPlacing.includeSameClub");
        boolean includeAllCompetitors = competitionSettings.get("clubPlacing.includeAllCompetitors") == null ? false : (Boolean)competitionSettings.get("clubPlacing.includeAllCompetitors");
        Club clubExample = new Club();
        clubExample.setStatus(Club.Status.ACTIVE);
        clubExample.setCountForClubPlacings(Boolean.TRUE);
        SimpleDataFilter clubDataFilter = new SimpleDataFilter();
        clubDataFilter.setFilter((Filter)new ExampleFilter((Object)clubExample));
        clubDataFilter.setItemLimit(Integer.valueOf(1000));
        clubDataFilter.setSort(new Sort());
        clubDataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        ArrayList<ClubPlacing> clubPlacings = new ArrayList<ClubPlacing>();
        for (Club club : this.getManagersList().getClubManager().find(competition, (DataFilter)clubDataFilter).getData()) {
            ClubPlacing clubPlacing = new ClubPlacing();
            clubPlacing.setClub(club);
            clubPlacing.setPoints(Integer.valueOf(0));
            clubPlacings.add(clubPlacing);
        }
        for (Category category : categories) {
            Map competitorPlacings;
            if (!category.getCountForClubPlacings().booleanValue() || !(category instanceof TreeCategory) || (competitorPlacings = this.getManagersList().getCategoryManager().getPlacings(category)) == null) continue;
            for (ClubPlacing clubPlacing : clubPlacings) {
                ClubCompetitorPoints clubCompetitorPoints = competitionRules.getPointsForClub(clubPlacing.getClub(), competitorPlacings, pointsForPlace, includeOneCompetitor, includeSameClub, includeAllCompetitors);
                if (clubCompetitorPoints.getTopPlace() == 1) {
                    clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_1() + 1));
                } else if (clubCompetitorPoints.getTopPlace() == 2) {
                    clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_2() + 1));
                } else if (clubCompetitorPoints.getTopPlace() == 3) {
                    clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_3() + 1));
                } else if (clubCompetitorPoints.getTopPlace() == 4) {
                    clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_4() + 1));
                } else if (clubCompetitorPoints.getTopPlace() == 5) {
                    clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_5() + 1));
                }
                clubPlacing.setPoints(Integer.valueOf(clubPlacing.getPoints() + clubCompetitorPoints.getPoints()));
            }
        }
        Collections.sort(clubPlacings, new Comparator<ClubPlacing>(){

            @Override
            public int compare(ClubPlacing o1, ClubPlacing o2) {
                int n = o1.getPoints().compareTo(o2.getPoints());
                if (n != 0) {
                    return -n;
                }
                n = o1.getPlace_1().compareTo(o2.getPlace_1());
                if (n != 0) {
                    return -n;
                }
                n = o1.getPlace_2().compareTo(o2.getPlace_2());
                if (n != 0) {
                    return -n;
                }
                n = o1.getPlace_3().compareTo(o2.getPlace_3());
                if (n != 0) {
                    return -n;
                }
                n = o1.getPlace_4().compareTo(o2.getPlace_4());
                if (n != 0) {
                    return -n;
                }
                n = o1.getPlace_5().compareTo(o2.getPlace_5());
                if (n != 0) {
                    return -n;
                }
                return 0;
            }
        });
        int placeNum = 1;
        for (ClubPlacing clubPlacing : clubPlacings) {
            clubPlacing.setPlace(Integer.valueOf(placeNum++));
        }
        model.addAttribute("clubPlacings", clubPlacings);
    }

    private void addCompetitorRankings(Competition competition, Model model) {
        List competitorRankings = this.getManagersList().getCompetitorManager().getCompetitorRankings(competition, Competitor.Type.COMPETITOR);
        while (competitorRankings.size() > 50) {
            competitorRankings.remove(competitorRankings.size() - 1);
        }
        model.addAttribute("competitorRankings", (Object)competitorRankings);
        List coupleRankings = this.getManagersList().getCompetitorManager().getCompetitorRankings(competition, Competitor.Type.COUPLE);
        while (coupleRankings.size() > 50) {
            coupleRankings.remove(coupleRankings.size() - 1);
        }
        model.addAttribute("coupleRankings", (Object)coupleRankings);
    }

    @RequestMapping(value={"/login"})
    public String login(Model model) {
        model.addAttribute("loginFailed", (Object)false);
        return "login";
    }

    @RequestMapping(value={"/login"}, params={"success=false"})
    public String login_failed(Model model) {
        model.addAttribute("loginFailed", (Object)true);
        return "login";
    }

    @RequestMapping(value={"/logout"})
    public String logout(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logoutHandler.logout(request, response, SecurityContextHolder.getContext().getAuthentication());
        SecurityContextHolder.clearContext();
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        return "redirect:/login";
    }

    @RequestMapping(value={"/config.js"})
    public String getJavaScriptConfig(HttpServletResponse response, Model model) {
        response.setContentType("text/javascript");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        return "jsconfig";
    }

    @RequestMapping(value={"/messages.js"})
    public String getMessages(HttpServletResponse response, Model model) {
        response.setContentType("text/javascript");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        model.addAttribute("messages", this.messages);
        return "jsmessages";
    }
}

