/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.reports.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import si.nevensrok.jtekma.server.reports.impl.MatchData;

public class MatchTreeImageGenerator {
    private static final Font font = new Font("Serif", 0, 9);
    private static final int sourceFieldWidth = 28;
    private static final int matchNumberFieldWidth = 20;
    private static final int nameFieldWidth = 120;
    private static final int nameFieldHeight = 14;
    private static final int pointsFieldWidth = 35;
    private static final int totalMatchWidth = 203;
    private static final int verticalSpace = 4;
    private static final int horizontalSpace = 0;
    private static final int matchSize = 32;
    private static final int doubleMatchSize = 64;

    public BufferedImage generateBestOf3Fights(List<MatchData> matchDatas) {
        BufferedImage image = new BufferedImage(620, 130, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (int i = 0; i < 3; ++i) {
            MatchData matchData = matchDatas.get(i);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 32, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTableFights(List<MatchData> matchDatas) {
        MatchData matchData;
        int i;
        BufferedImage image = new BufferedImage(620, 200, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (i = 0; i < 5; ++i) {
            matchData = matchDatas.get(i);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 32, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 5; ++i) {
            matchData = matchDatas.get(5 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203, i * 32, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTree4Fights(List<MatchData> matchDatas, boolean display3rdPlaceMatch) {
        BufferedImage image = new BufferedImage(620, 120, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (int i = 0; i < 2; ++i) {
            MatchData matchData = matchDatas.get(i);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 32, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        MatchData matchData = matchDatas.get(3);
        MatchTreeImageGenerator.drawMatch(graphics, 203, 16, matchData);
        graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        if (display3rdPlaceMatch) {
            matchData = matchDatas.get(2);
            MatchTreeImageGenerator.drawMatch(graphics, 203, 80, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTree8Fights(List<MatchData> matchDatas, boolean displayRepassage, boolean display3rdPlaceMatch) {
        MatchData matchData;
        int i;
        BufferedImage image = new BufferedImage(620, 440, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(i);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(4 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 101, 32 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        MatchData matchData2 = matchDatas.get(11);
        MatchTreeImageGenerator.drawMatch(graphics, 202, 96, matchData2);
        graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        if (displayRepassage) {
            MatchData matchData3;
            int i2;
            int topOffset = 264;
            for (i2 = 0; i2 < 2; ++i2) {
                matchData3 = matchDatas.get(6 + i2);
                MatchTreeImageGenerator.drawMatch(graphics, 0, topOffset + i2 * 64, matchData3);
                graphics.setClip(0, 0, image.getWidth(), image.getHeight());
            }
            for (i2 = 0; i2 < 2; ++i2) {
                matchData3 = matchDatas.get(8 + i2);
                MatchTreeImageGenerator.drawMatch(graphics, 203, topOffset + i2 * 64, matchData3);
                graphics.setClip(0, 0, image.getWidth(), image.getHeight());
            }
            if (display3rdPlaceMatch) {
                MatchData matchData4 = matchDatas.get(10);
                MatchTreeImageGenerator.drawMatch(graphics, 271, topOffset + 32, matchData4);
                graphics.setClip(0, 0, image.getWidth(), image.getHeight());
            }
        }
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTree16Fights(List<MatchData> matchDatas) {
        MatchData matchData;
        int i;
        BufferedImage image = new BufferedImage(620, 260, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (i = 0; i < 8; ++i) {
            matchData = matchDatas.get(i);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 32, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(8 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203, 16 + i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(20 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 304, 48 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        MatchData matchData2 = matchDatas.get(27);
        MatchTreeImageGenerator.drawMatch(graphics, 406, 112, matchData2);
        graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTree16RepassageFights(List<MatchData> matchDatas, boolean display3rdPlaceMatch) {
        MatchData matchData;
        int i;
        BufferedImage image = new BufferedImage(620, 260, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(12 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(16 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203, i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(22 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 208, 32 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(24 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 411, 32 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        if (display3rdPlaceMatch) {
            MatchData matchData2 = matchDatas.get(26);
            MatchTreeImageGenerator.drawMatch(graphics, 416, 96, matchData2);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTree32Fights(List<MatchData> matchDatas) {
        MatchData matchData;
        int i;
        BufferedImage image = new BufferedImage(620, 520, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (i = 0; i < 16; ++i) {
            matchData = matchDatas.get(i);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 32, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 8; ++i) {
            matchData = matchDatas.get(16 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203, 16 + i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(40 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203 + Math.round(92.27273f), 48 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(52 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203 + Math.round(156.15385f), 112 + i * 256, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        MatchData matchData2 = matchDatas.get(59);
        MatchTreeImageGenerator.drawMatch(graphics, 406, 240, matchData2);
        graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTree32RepassageFights(List<MatchData> matchDatas, boolean display3rdPlaceMatch) {
        MatchData matchData;
        int i;
        BufferedImage image = new BufferedImage(840, 520, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (i = 0; i < 8; ++i) {
            matchData = matchDatas.get(24 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 8; ++i) {
            matchData = matchDatas.get(32 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203, i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(44 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 208, 32 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(48 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 411, 32 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(54 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 416, 96 + i * 256, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(56 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 619, 96 + i * 256, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        if (display3rdPlaceMatch) {
            MatchData matchData2 = matchDatas.get(58);
            MatchTreeImageGenerator.drawMatch(graphics, 624, 224, matchData2);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTree64_1Fights(List<MatchData> matchDatas) {
        MatchData matchData;
        int i;
        BufferedImage image = new BufferedImage(620, 520, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (i = 0; i < 16; ++i) {
            matchData = matchDatas.get(i);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 32, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 8; ++i) {
            matchData = matchDatas.get(32 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203, 16 + i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(80 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203 + Math.round(92.27273f), 48 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(104 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203 + Math.round(156.15385f), 112 + i * 256, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        MatchData matchData2 = matchDatas.get(116);
        MatchTreeImageGenerator.drawMatch(graphics, 406, 240, matchData2);
        graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTree64_2Fights(List<MatchData> matchDatas) {
        MatchData matchData;
        int i;
        BufferedImage image = new BufferedImage(620, 520, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (i = 0; i < 16; ++i) {
            matchData = matchDatas.get(i + 16);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 32, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 8; ++i) {
            matchData = matchDatas.get(40 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203, 16 + i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(84 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203 + Math.round(92.27273f), 48 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(106 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203 + Math.round(156.15385f), 112 + i * 256, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        MatchData matchData2 = matchDatas.get(117);
        MatchTreeImageGenerator.drawMatch(graphics, 406, 240, matchData2);
        graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTree64_1RepassageFights(List<MatchData> matchDatas) {
        MatchData matchData;
        int i;
        BufferedImage image = new BufferedImage(840, 520, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (i = 0; i < 8; ++i) {
            matchData = matchDatas.get(48 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 8; ++i) {
            matchData = matchDatas.get(64 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203, i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(88 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 208, 32 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(96 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 411, 32 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(108 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 416, 96 + i * 256, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(112 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 619, 96 + i * 256, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        MatchData matchData2 = matchDatas.get(118);
        MatchTreeImageGenerator.drawMatch(graphics, 624, 224, matchData2);
        graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTree64_2RepassageFights(List<MatchData> matchDatas) {
        MatchData matchData;
        int i;
        BufferedImage image = new BufferedImage(840, 520, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (i = 0; i < 8; ++i) {
            matchData = matchDatas.get(56 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 8; ++i) {
            matchData = matchDatas.get(72 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 203, i * 64, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(92 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 208, 32 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 4; ++i) {
            matchData = matchDatas.get(100 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 411, 32 + i * 128, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(110 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 416, 96 + i * 256, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        for (i = 0; i < 2; ++i) {
            matchData = matchDatas.get(114 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 619, 96 + i * 256, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        MatchData matchData2 = matchDatas.get(119);
        MatchTreeImageGenerator.drawMatch(graphics, 624, 224, matchData2);
        graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTree64FinalsFights(List<MatchData> matchDatas) {
        BufferedImage image = new BufferedImage(210, 40, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        MatchData matchData = matchDatas.get(123);
        MatchTreeImageGenerator.drawMatch(graphics, 0, 0, matchData);
        graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        graphics.dispose();
        return image;
    }

    public BufferedImage generateTree64ForThirdFights(List<MatchData> matchDatas, boolean display3rdPlaceMatch) {
        BufferedImage image = new BufferedImage(420, 70, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (int i = 0; i < 2; ++i) {
            MatchData matchData = matchDatas.get(120 + i);
            MatchTreeImageGenerator.drawMatch(graphics, 0, i * 32, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        if (display3rdPlaceMatch) {
            MatchData matchData = matchDatas.get(122);
            MatchTreeImageGenerator.drawMatch(graphics, 203, 16, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        graphics.dispose();
        return image;
    }

    public BufferedImage generateMatchRowFights(List<MatchData> matchDatas) {
        BufferedImage image = new BufferedImage(620, 40, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        for (int i = 0; i < 3 && i < matchDatas.size(); ++i) {
            MatchData matchData = matchDatas.get(i);
            MatchTreeImageGenerator.drawMatch(graphics, i * 203, 0, matchData);
            graphics.setClip(0, 0, image.getWidth(), image.getHeight());
        }
        graphics.dispose();
        return image;
    }

    private static void drawMatch(Graphics2D graphics, int x, int y, MatchData matchData) {
        graphics.drawLine(x + 28, y, x + 28 + 120 + 35, y);
        graphics.drawLine(x + 28, y + 14, x + 28 + 120 + 35, y + 14);
        graphics.drawLine(x + 28, y + 28, x + 28 + 120 + 35, y + 28);
        graphics.drawLine(x + 28, y, x + 28, y + 28);
        graphics.drawLine(x + 28 + 120, y, x + 28 + 120, y + 28);
        graphics.drawLine(x + 28 + 120 + 35, y, x + 28 + 120 + 35, y + 28);
        if (matchData.getSourceCompetitor1() != null) {
            MatchTreeImageGenerator.writeText(graphics, matchData.getSourceCompetitor1(), x, y, 28, 14, HorizontalAlignment.RIGHT);
        }
        MatchTreeImageGenerator.writeText(graphics, matchData.getCompetitor1(), x + 28 + 2, y, 117, 14, HorizontalAlignment.LEFT);
        MatchTreeImageGenerator.writeText(graphics, matchData.getPoints1(), x + 28 + 120, y, 35, 14, HorizontalAlignment.CENTER);
        if (matchData.getSourceCompetitor2() != null) {
            MatchTreeImageGenerator.writeText(graphics, matchData.getSourceCompetitor2(), x, y + 14, 28, 14, HorizontalAlignment.RIGHT);
        }
        MatchTreeImageGenerator.writeText(graphics, matchData.getCompetitor2(), x + 28 + 2, y + 14, 117, 14, HorizontalAlignment.LEFT);
        MatchTreeImageGenerator.writeText(graphics, matchData.getPoints2(), x + 28 + 120, y + 14, 35, 14, HorizontalAlignment.CENTER);
        if (matchData.getMatchNumber() != null) {
            MatchTreeImageGenerator.writeText(graphics, matchData.getMatchNumber(), x + 28 + 120 + 35 + 2, y + 7, 20, 14, HorizontalAlignment.LEFT);
        }
    }

    private static void writeText(Graphics2D graphics, String text, int x, int y, int width, int height, HorizontalAlignment alignment) {
        Dimension textSize = MatchTreeImageGenerator.getTextSize(graphics, text);
        graphics.setClip(x, y, width, height);
        int poxX = 0;
        int posY = Math.round((float)y + ((float)height + (float)textSize.getHeight()) / 2.0f);
        poxX = alignment == HorizontalAlignment.CENTER ? x + Math.round(((float)width - (float)textSize.getWidth()) / 2.0f) : (alignment == HorizontalAlignment.RIGHT ? x + width - (int)textSize.getWidth() : x);
        graphics.drawString(text, poxX, posY);
    }

    private static Dimension getTextSize(Graphics2D graphics, String text) {
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int height = fontMetrics.getHeight();
        int width = fontMetrics.stringWidth(text);
        return new Dimension(width, height);
    }

    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

