/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.reports.impl;

import java.io.InputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathResourceLoader
extends ResourceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathResourceLoader.class);
    public static final String PATH = "path";
    private String resourcePath = "/";

    public void init(ExtendedProperties configuration) {
        LOGGER.debug("Initializing LocalResorceLoader");
        this.resourcePath = configuration.getString(PATH);
        LOGGER.debug("Resource path: {}" + this.resourcePath);
        if (!this.resourcePath.endsWith("/")) {
            this.resourcePath = this.resourcePath + "/";
        }
        LOGGER.debug("LocalResorceLoader initialized");
    }

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        InputStream inputStream = null;
        try {
            inputStream = source.startsWith("/") ? ClassUtils.getResourceAsStream(((Object)((Object)this)).getClass(), (String)source) : ClassUtils.getResourceAsStream(((Object)((Object)this)).getClass(), (String)(this.resourcePath + source));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while loading resource " + source, e);
        }
        return inputStream;
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

