/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.security.cert.CertificateException;
import java.util.Calendar;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAKeyParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import si.nevensrok.common.ssl.BcCertificateChainVerifier;
import si.nevensrok.common.ssl.BcCertificateRepository;
import si.nevensrok.common.ssl.BcKeyManager;
import si.nevensrok.common.ssl.BcRevokedCertificateChecker;

public class BcKeyManagerImpl
implements BcKeyManager {
    private static final String KEY_TYPE_EC = "EC";
    private static final String KEY_TYPE_RSA = "RSA";
    private static final String KEY_TYPE_DSA = "DSA";
    private boolean checkDate = true;
    private boolean checkWithDateGracePeriod = true;
    private BcCertificateRepository certificateRepository;
    private BcRevokedCertificateChecker revokedCertificateChecker;

    public void setCertificateRepository(BcCertificateRepository certificateRepository) {
        this.certificateRepository = certificateRepository;
    }

    public BcKeyManagerImpl() {
    }

    public void setCheckDate(boolean checkDate) {
        this.checkDate = checkDate;
    }

    public void setCheckWithDateGracePeriod(boolean checkWithDateGracePeriod) {
        this.checkWithDateGracePeriod = checkWithDateGracePeriod;
    }

    public BcKeyManagerImpl(BcCertificateRepository certificateRepository) {
        this.certificateRepository = certificateRepository;
    }

    public void setRevokedCertificateChecker(BcRevokedCertificateChecker revokedCertificateChecker) {
        this.revokedCertificateChecker = revokedCertificateChecker;
    }

    @Override
    public String chooseAlias(String keyType) {
        if (this.certificateRepository != null) {
            for (String alias : this.certificateRepository.getAliasesWithPrivateKey()) {
                BcTlsCertificate certificate;
                AsymmetricKeyParameter privateKey = this.certificateRepository.getPrivateKey(alias);
                if (privateKey instanceof RSAKeyParameters) {
                    if (!KEY_TYPE_RSA.equalsIgnoreCase(keyType)) {
                        continue;
                    }
                } else if (!(privateKey instanceof DSAKeyParameters) ? privateKey instanceof ECKeyParameters && !KEY_TYPE_EC.equalsIgnoreCase(keyType) : !KEY_TYPE_DSA.equalsIgnoreCase(keyType)) continue;
                if (!this.isCertificateValid((TlsCertificate)(certificate = this.certificateRepository.getBcTlsCertificate(alias)))) continue;
                return alias;
            }
        }
        return null;
    }

    @Override
    public String chooseAlias(List<String> keyTypes, List<X500Name> certificateAuthorities) {
        if (this.certificateRepository != null) {
            for (String alias : this.certificateRepository.getAliasesWithPrivateKey()) {
                AsymmetricKeyParameter privateKey = this.certificateRepository.getPrivateKey(alias);
                if (privateKey instanceof RSAKeyParameters ? !this.isKeyType(KEY_TYPE_RSA, keyTypes) : (privateKey instanceof DSAKeyParameters ? !this.isKeyType(KEY_TYPE_DSA, keyTypes) : privateKey instanceof ECKeyParameters && !this.isKeyType(KEY_TYPE_EC, keyTypes))) continue;
                BcTlsCertificate[] tlsChain = this.certificateRepository.getBcTlsCertificateChain(alias);
                Certificate[] chain = this.certificateRepository.getCertificateChain(alias);
                if (!this.isCertificateValid((TlsCertificate)tlsChain[0])) continue;
                for (X500Name ca : certificateAuthorities) {
                    if (!this.areNameEqual(chain[chain.length - 1].getIssuer(), ca) || !this.isChainValid((TlsCertificate[])tlsChain)) continue;
                    return alias;
                }
            }
        }
        return null;
    }

    @Override
    public BcTlsCertificate getCertificate(String alias) {
        return this.certificateRepository.getBcTlsCertificate(alias);
    }

    @Override
    public BcTlsCertificate[] getCertificateChain(String alias) {
        return this.certificateRepository.getBcTlsCertificateChain(alias);
    }

    @Override
    public AsymmetricKeyParameter getPrivateKey(String alias) {
        return this.certificateRepository.getPrivateKey(alias);
    }

    protected boolean isCertificateValid(TlsCertificate certificate) {
        try {
            new BcCertificateChainVerifier().withCheckDate(this.checkDate).withCalendars(this.generateCalendarsToCheck()).withCertificate(certificate).withRevokedCertificateChecker(this.revokedCertificateChecker).withNoCaCheck(true).check();
            return true;
        }
        catch (CertificateException e) {
            return false;
        }
    }

    protected Calendar[] generateCalendarsToCheck() {
        if (this.checkWithDateGracePeriod) {
            Calendar now = Calendar.getInstance();
            Calendar past = (Calendar)now.clone();
            past.add(13, -60);
            Calendar future = (Calendar)now.clone();
            future.add(13, 60);
            return new Calendar[]{now, past, future};
        }
        return new Calendar[]{Calendar.getInstance()};
    }

    protected boolean isKeyType(String keyType, List<String> possibleKeyTypes) {
        for (String kt : possibleKeyTypes) {
            if (!keyType.equalsIgnoreCase(kt)) continue;
            return true;
        }
        return false;
    }

    protected boolean areNameEqual(X500Name name1, X500Name name2) {
        return name1.equals((Object)name2);
    }

    protected boolean isChainValid(TlsCertificate[] chain) {
        try {
            new BcCertificateChainVerifier().withCheckDate(this.checkDate).withCalendars(this.generateCalendarsToCheck()).withCertificateChain(chain).withRevokedCertificateChecker(this.revokedCertificateChecker).withNoCaCheck(true).check();
            return true;
        }
        catch (CertificateException e) {
            return false;
        }
    }
}

