/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.qrcode.codes;

import java.io.Serializable;
import si.nevensrok.common.qrcode.QRCode;
import si.nevensrok.common.qrcode.QRCodeException;
import si.nevensrok.common.qrcode.QRCodeType;

public class QRSmsCode
implements QRCode,
Serializable {
    private static final long serialVersionUID = -942697625522340285L;
    private String recipient;
    private String message;

    public QRSmsCode() {
    }

    public QRSmsCode(String recipient, String message) {
        this.recipient = recipient;
        this.message = message;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getCodeText() {
        return "smsto:" + this.recipient + ":" + this.message;
    }

    @Override
    public QRCodeType getType() {
        return QRCodeType.SMS;
    }

    @Override
    public void parseCode(String text) throws QRCodeException {
        try {
            if (!text.startsWith("smsto:")) {
                throw new QRCodeException("Not a SMS QR code!");
            }
            text = text.substring(6, text.length());
            int n = text.indexOf(58);
            this.recipient = text.substring(0, n);
            this.message = text.substring(n + 1, text.length());
        }
        catch (QRCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QRCodeException("Error while parsing QR code", e);
        }
    }

    public String toString() {
        return "QRSmsCode [recipient=" + this.recipient + ", message=" + this.message + "]";
    }
}

