/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.lock;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Random;
import javax.sql.DataSource;
import si.nevensrok.common.lock.AbstractExternalLock;

class DatabaseLock
extends AbstractExternalLock {
    private static final long CHECKIN_TIMEOUT = 10000L;
    private static final Random RANDOM = new Random();
    private DataSource dataSource;
    private String memberId;
    private String locksTableName;
    private String membersTableName;

    DatabaseLock(DataSource dataSource, String memberId, String name, String locksTableName, String membersTableName) {
        super(name);
        this.dataSource = dataSource;
        this.memberId = memberId;
        this.locksTableName = locksTableName;
        this.membersTableName = membersTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearExpiredLock() {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            StringBuilder sql = new StringBuilder();
            sql.append("delete from ");
            sql.append(this.locksTableName);
            sql.append(" where lockname=?");
            sql.append(" and exists (select 1 from ");
            sql.append(this.membersTableName);
            sql.append(" where ");
            sql.append(this.locksTableName);
            sql.append(".memberid=");
            sql.append(this.membersTableName);
            sql.append(".memberid and lastcheckin<?)");
            preparedStatement = connection.prepareStatement(sql.toString());
            preparedStatement.setString(1, this.getName());
            preparedStatement.setTimestamp(2, new Timestamp(System.currentTimeMillis() - 10000L));
            preparedStatement.execute();
            preparedStatement.close();
            connection.commit();
        }
        catch (Throwable e) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable sql) {}
            }
        }
    }

    @Override
    protected boolean isLocked() {
        return this.getLockMemberId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLockMemberId() {
        String string;
        String lockMemberId = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            StringBuilder sql = new StringBuilder();
            sql.append("select memberid from ");
            sql.append(this.locksTableName);
            sql.append(" where lockname=?");
            sql.append(" and exists (select 1 from ");
            sql.append(this.membersTableName);
            sql.append(" where ");
            sql.append(this.locksTableName);
            sql.append(".memberid=");
            sql.append(this.membersTableName);
            sql.append(".memberid and lastcheckin<?)");
            preparedStatement = connection.prepareStatement(sql.toString());
            preparedStatement.setString(1, this.getName());
            preparedStatement.setTimestamp(2, new Timestamp(System.currentTimeMillis() - 10000L));
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                lockMemberId = resultSet.getString("1");
            }
            resultSet.close();
            preparedStatement.close();
            connection.commit();
            string = lockMemberId;
            if (connection == null) return string;
        }
        catch (Throwable e) {
            try {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                String string2 = "";
                return string2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        try {
            connection.close();
            return string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean acquireLock() {
        boolean bl;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            StringBuilder sql = new StringBuilder();
            sql.append("insert into ");
            sql.append(this.locksTableName);
            sql.append(" (lockname,lockedat,memberid) values (?,?,?)");
            preparedStatement = connection.prepareStatement(sql.toString());
            preparedStatement.setString(1, this.getName());
            preparedStatement.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            preparedStatement.setString(3, this.memberId);
            preparedStatement.execute();
            preparedStatement.close();
            connection.commit();
            bl = true;
            if (connection == null) return bl;
        }
        catch (Throwable e) {
            try {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                boolean bl2 = false;
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        try {
            connection.close();
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    @Override
    protected void cancelLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeLock() {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            StringBuilder sql = new StringBuilder();
            sql.append("delete from ");
            sql.append(this.locksTableName);
            sql.append(" where lockname=?");
            sql.append(" and memberid=?");
            preparedStatement = connection.prepareStatement(sql.toString());
            preparedStatement.setString(1, this.getName());
            preparedStatement.setString(2, this.memberId);
            preparedStatement.execute();
            preparedStatement.close();
            connection.commit();
        }
        catch (Throwable e) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable sql) {}
            }
        }
    }

    @Override
    protected void waitUntilNextTry(long maxWaitTime) throws InterruptedException {
        long sleepTime = Math.min(300L + (long)RANDOM.nextInt(1000), maxWaitTime);
        if (sleepTime > 0L) {
            Thread.sleep(sleepTime);
        }
    }
}

