/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.buffer;

import java.io.Serializable;
import si.nevensrok.common.utils.ArrayUtil;

public class DynamicFloatBuffer
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3723710421703693456L;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private float[] buffer;
    private int startPos = 0;
    private int endPos = 0;
    private int maxSize = Integer.MAX_VALUE;

    public DynamicFloatBuffer() {
        this(4096);
    }

    public DynamicFloatBuffer(float[] data) {
        this.buffer = data;
    }

    public DynamicFloatBuffer(int initialSize) {
        this.buffer = new float[initialSize];
    }

    public DynamicFloatBuffer(int initialSize, int maxSize) {
        this(initialSize);
        this.maxSize = maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public synchronized void clear() {
        this.startPos = 0;
        this.endPos = 0;
        this.notifyAll();
    }

    public synchronized void close() {
        this.buffer = null;
        this.startPos = 0;
        this.endPos = 0;
        this.notifyAll();
    }

    public boolean isBufferFull() {
        return this.getAvailableCapacity() == 0;
    }

    public int getAvailableCapacity() {
        return this.getMaxSize() - this.getDataAvailable();
    }

    public boolean isBufferEmpty() {
        return this.getDataAvailable() == 0;
    }

    public int getDataAvailable() {
        return this.endPos - this.startPos;
    }

    public int getCurrentBufferSize() {
        return this.buffer.length;
    }

    private void rewind() {
        int len = this.getDataAvailable();
        for (int i = 0; i < len; ++i) {
            this.buffer[i] = this.buffer[i + this.startPos];
        }
        this.endPos -= this.startPos;
        this.startPos = 0;
    }

    public synchronized void add(float b) {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (this.isBufferFull()) {
            throw new IllegalStateException("Maximum buffer size reached");
        }
        if (this.endPos >= this.buffer.length) {
            if (this.startPos >= this.buffer.length / 2) {
                this.rewind();
            } else {
                float[] newBuffer = new float[Math.min(Math.max(4096, this.buffer.length * 2), this.maxSize)];
                System.arraycopy(this.buffer, this.startPos, newBuffer, 0, this.endPos - this.startPos);
                this.buffer = newBuffer;
                this.endPos -= this.startPos;
                this.startPos = 0;
            }
        }
        this.buffer[this.endPos++] = b;
        this.notifyAll();
    }

    public synchronized void add(float[] data) {
        this.add(data, 0, data.length);
    }

    public synchronized void add(float[] data, int offset, int length) {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (length == 0) {
            return;
        }
        if (this.isBufferFull()) {
            throw new IllegalStateException("Maximum buffer size reached");
        }
        int neededLength = this.getDataAvailable() + length;
        if (neededLength > this.maxSize) {
            throw new IllegalStateException("Not enough space available in buffer");
        }
        if (this.endPos + length > this.buffer.length) {
            if (this.startPos >= this.buffer.length / 2) {
                this.rewind();
            } else {
                float[] newBuffer = new float[Math.min(Math.max(Math.max(4096, this.buffer.length * 2), neededLength), this.maxSize)];
                System.arraycopy(this.buffer, this.startPos, newBuffer, 0, this.endPos - this.startPos);
                this.buffer = newBuffer;
                this.endPos -= this.startPos;
                this.startPos = 0;
            }
        }
        System.arraycopy(data, offset, this.buffer, this.endPos, length);
        this.endPos += length;
        this.notifyAll();
    }

    public synchronized void addBlocking(float b) throws InterruptedException {
        while (true) {
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (!this.isBufferFull()) break;
            this.wait();
        }
        if (this.endPos >= this.buffer.length) {
            if (this.startPos > 0) {
                this.rewind();
            } else {
                float[] newBuffer = new float[Math.min(Math.max(4096, this.buffer.length * 2), this.maxSize)];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.endPos);
                this.buffer = newBuffer;
            }
        }
        this.buffer[this.endPos++] = b;
        this.notifyAll();
    }

    public synchronized void addBlocking(float[] data) throws InterruptedException {
        this.addBlocking(data, 0, data.length);
    }

    public synchronized void addBlocking(float[] data, int offset, int length) throws InterruptedException {
        int neededLength;
        if (length == 0) {
            return;
        }
        while (true) {
            neededLength = this.getDataAvailable() + length;
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (neededLength <= this.maxSize) break;
            this.wait();
        }
        if (this.endPos + length > this.buffer.length) {
            if (this.startPos >= length) {
                this.rewind();
            } else {
                float[] newBuffer = new float[Math.min(Math.max(Math.max(4096, this.buffer.length * 2), neededLength), this.maxSize)];
                System.arraycopy(this.buffer, this.startPos, newBuffer, 0, this.endPos - this.startPos);
                this.buffer = newBuffer;
                this.endPos -= this.startPos;
                this.startPos = 0;
            }
        }
        System.arraycopy(data, offset, this.buffer, this.endPos, length);
        this.endPos += length;
        this.notifyAll();
    }

    public synchronized float get() {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (this.startPos >= this.endPos) {
            throw new IllegalStateException("Buffer is empty");
        }
        this.notifyAll();
        return this.buffer[this.startPos++];
    }

    public synchronized void get(float[] data) {
        this.get(data, 0, data.length);
    }

    public synchronized void get(float[] data, int offset, int length) {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (length == 0) {
            return;
        }
        if (this.startPos >= this.endPos) {
            throw new IllegalStateException("Buffer is empty");
        }
        if (this.getDataAvailable() < length) {
            throw new IllegalStateException("Not enough data available in buffer");
        }
        System.arraycopy(this.buffer, this.startPos, data, offset, length);
        this.startPos += length;
        this.notifyAll();
    }

    public synchronized float[] get(int length) {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (length == 0) {
            return new float[0];
        }
        if (this.startPos >= this.endPos) {
            throw new IllegalStateException("Buffer is empty");
        }
        if (this.getDataAvailable() < length) {
            throw new IllegalStateException("Not enough data available in buffer");
        }
        float[] data = new float[length];
        System.arraycopy(this.buffer, this.startPos, data, 0, length);
        this.startPos += length;
        this.notifyAll();
        return data;
    }

    public synchronized float[] getAll() {
        return this.get(this.getDataAvailable());
    }

    public synchronized float getBlocking() throws InterruptedException {
        while (true) {
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (this.startPos < this.endPos) break;
            this.wait();
        }
        this.notifyAll();
        return this.buffer[this.startPos++];
    }

    public synchronized void getBlocking(float[] data) throws InterruptedException {
        this.get(data, 0, data.length);
    }

    public synchronized void getBlocking(float[] data, int offset, int length) throws InterruptedException {
        if (length == 0) {
            return;
        }
        while (true) {
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (this.getDataAvailable() >= length) break;
            this.wait();
        }
        System.arraycopy(this.buffer, this.startPos, data, offset, length);
        this.startPos += length;
        this.notifyAll();
    }

    public synchronized float[] getBlocking(int length) throws InterruptedException {
        if (length == 0) {
            return new float[0];
        }
        while (true) {
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (this.getDataAvailable() >= length) break;
            this.wait();
        }
        float[] data = new float[length];
        System.arraycopy(this.buffer, this.startPos, data, 0, length);
        this.startPos += length;
        this.notifyAll();
        return data;
    }

    public synchronized float[] getAllBlocking() throws InterruptedException {
        return this.getBlocking(this.getDataAvailable());
    }

    public synchronized void remove(int length) {
        if (length == 0) {
            return;
        }
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed");
        }
        if (this.startPos >= this.endPos) {
            throw new IllegalStateException("Buffer is empty");
        }
        if (this.getDataAvailable() < length) {
            throw new IllegalStateException("Not enough data available in buffer");
        }
        this.startPos += length;
        this.notifyAll();
    }

    public synchronized void removeBlocking(int length) throws InterruptedException {
        if (length == 0) {
            return;
        }
        while (true) {
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (this.getDataAvailable() >= length) break;
            this.wait();
        }
        this.startPos += length;
        this.notifyAll();
    }

    public synchronized void waitForData() throws InterruptedException {
        this.waitForData(1);
    }

    public synchronized void waitForData(int length) throws InterruptedException {
        if (length == 0) {
            return;
        }
        while (true) {
            if (this.buffer == null) {
                throw new IllegalStateException("Buffer is closed");
            }
            if (this.getDataAvailable() >= length) break;
            this.wait();
        }
        this.notifyAll();
    }

    public synchronized float[] getCopyOfCurrentBuffer() {
        return ArrayUtil.subArray((float[])this.buffer, (int)this.startPos, (int)(this.endPos - this.startPos));
    }

    public synchronized DynamicFloatBuffer clone() {
        try {
            DynamicFloatBuffer clone = (DynamicFloatBuffer)super.clone();
            clone.buffer = ArrayUtil.copyArray((float[])this.buffer);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Cloning failed", e);
        }
    }
}

