/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.request;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import si.nevensrok.common.request.Callback;
import si.nevensrok.common.request.FutureResult;
import si.nevensrok.common.request.RequestExecutor;

public abstract class AbstractAsyncRequestExecutor<R, S>
implements RequestExecutor<R, S> {
    private long timeout = 0L;

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public abstract void executeAsync(R var1, Callback<S> var2);

    @Override
    public Future<S> executeAsync(R request) {
        FutureResult futureResult = new FutureResult();
        this.executeAsync(request, futureResult);
        return futureResult;
    }

    @Override
    public S executeSync(R request) throws Throwable {
        Future<S> future = this.executeAsync(request);
        try {
            if (this.timeout > 0L) {
                return future.get(this.timeout, TimeUnit.MILLISECONDS);
            }
            return future.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }
}

