/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.NetworkMessageHandler;

public class MessageReceiver {
    private static final Logger log = LoggerFactory.getLogger(MessageReceiver.class);
    private boolean open = true;
    private NetworkMessageHandler networkMessageHandler;

    public MessageReceiver(final DatagramSocket socket, final int bufferSize, final Executor executor, NetworkMessageHandler nmh) {
        this.networkMessageHandler = nmh;
        Thread thread = new Thread("Message receive thread for socket [" + socket.getLocalAddress().getHostAddress() + "]:" + socket.getLocalPort()){

            @Override
            public void run() {
                log.debug("Message receive thread started");
                byte[] buffer = new byte[bufferSize];
                while (MessageReceiver.this.open) {
                    try {
                        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                        socket.receive(packet);
                        InetAddress sender = packet.getAddress();
                        Integer senderPort = packet.getPort();
                        byte[] data = new byte[packet.getLength()];
                        System.arraycopy(buffer, 0, data, 0, packet.getLength());
                        final NetworkMessage networkMessage = MessageReceiver.this.generateNetworkMessage(sender, senderPort, data);
                        log.trace("Received message: {}", (Object)networkMessage);
                        if (MessageReceiver.this.networkMessageHandler == null) continue;
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    MessageReceiver.this.networkMessageHandler.handleMessage(networkMessage);
                                }
                                catch (Throwable e) {
                                    log.error("Error handling network message", e);
                                }
                            }
                        };
                        if (executor != null) {
                            executor.execute(runnable);
                            continue;
                        }
                        runnable.run();
                    }
                    catch (Exception e) {
                        log.trace("Error while receiving message", (Throwable)e);
                    }
                }
                log.debug("Message receive thread stopped");
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.open = false;
    }

    public void setNetworkMessageHandler(NetworkMessageHandler networkMessageHandler) {
        this.networkMessageHandler = networkMessageHandler;
    }

    protected NetworkMessage generateNetworkMessage(InetAddress sender, Integer senderPort, byte[] data) throws Exception {
        return new NetworkMessage(sender, senderPort, data);
    }
}

