/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.ByteToIntPixelConverter;
import com.sun.javafx.image.IntPixelGetter;
import com.sun.javafx.image.IntPixelSetter;
import com.sun.javafx.image.IntToBytePixelConverter;
import com.sun.javafx.image.IntToIntPixelConverter;
import com.sun.javafx.image.PixelConverter;
import com.sun.javafx.image.PixelGetter;
import com.sun.javafx.image.PixelSetter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.ByteBgra;
import com.sun.javafx.image.impl.ByteBgraPre;
import com.sun.javafx.image.impl.ByteGray;
import com.sun.javafx.image.impl.ByteGrayAlpha;
import com.sun.javafx.image.impl.ByteGrayAlphaPre;
import com.sun.javafx.image.impl.ByteRgb;
import com.sun.javafx.image.impl.ByteRgba;
import com.sun.javafx.tk.PlatformImage;
import com.sun.prism.PixelFormat;
import com.sun.prism.impl.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritablePixelFormat;

public class Image
implements PlatformImage {
    static final WritablePixelFormat<ByteBuffer> FX_ByteBgraPre_FORMAT = javafx.scene.image.PixelFormat.getByteBgraPreInstance();
    static final WritablePixelFormat<IntBuffer> FX_IntArgbPre_FORMAT = javafx.scene.image.PixelFormat.getIntArgbPreInstance();
    static final javafx.scene.image.PixelFormat<ByteBuffer> FX_ByteRgb_FORMAT = javafx.scene.image.PixelFormat.getByteRgbInstance();
    private final Buffer pixelBuffer;
    private final int minX;
    private final int minY;
    private final int width;
    private final int height;
    private final int scanlineStride;
    private final PixelFormat pixelFormat;
    private final float pixelScale;
    int[] serial = new int[1];
    private Accessor<?> pixelaccessor;
    static javafx.scene.image.PixelFormat<ByteBuffer> FX_ByteGray_FORMAT;

    public static Image fromIntArgbPreData(int[] pixels, int width, int height) {
        return new Image(PixelFormat.INT_ARGB_PRE, pixels, width, height);
    }

    public static Image fromIntArgbPreData(IntBuffer pixels, int width, int height) {
        return new Image(PixelFormat.INT_ARGB_PRE, pixels, width, height);
    }

    public static Image fromIntArgbPreData(IntBuffer pixels, int width, int height, int scanlineStride) {
        return new Image(PixelFormat.INT_ARGB_PRE, pixels, width, height, 0, 0, scanlineStride);
    }

    public static Image fromIntArgbPreData(IntBuffer pixels, int width, int height, int scanlineStride, float pixelScale) {
        return new Image(PixelFormat.INT_ARGB_PRE, pixels, width, height, 0, 0, scanlineStride, pixelScale);
    }

    public static Image fromByteBgraPreData(byte[] pixels, int width, int height) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, pixels, width, height);
    }

    public static Image fromByteBgraPreData(byte[] pixels, int width, int height, float pixelScale) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, ByteBuffer.wrap(pixels), width, height, 0, 0, 0, pixelScale);
    }

    public static Image fromByteBgraPreData(ByteBuffer pixels, int width, int height) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, pixels, width, height);
    }

    public static Image fromByteBgraPreData(ByteBuffer pixels, int width, int height, int scanlineStride) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, pixels, width, height, 0, 0, scanlineStride);
    }

    public static Image fromByteBgraPreData(ByteBuffer pixels, int width, int height, int scanlineStride, float pixelScale) {
        return new Image(PixelFormat.BYTE_BGRA_PRE, pixels, width, height, 0, 0, scanlineStride, pixelScale);
    }

    public static Image fromByteRgbData(byte[] pixels, int width, int height) {
        return new Image(PixelFormat.BYTE_RGB, pixels, width, height);
    }

    public static Image fromByteRgbData(ByteBuffer pixels, int width, int height) {
        return new Image(PixelFormat.BYTE_RGB, pixels, width, height);
    }

    public static Image fromByteRgbData(ByteBuffer pixels, int width, int height, int scanlineStride) {
        return new Image(PixelFormat.BYTE_RGB, pixels, width, height, 0, 0, scanlineStride);
    }

    public static Image fromByteRgbData(ByteBuffer pixels, int width, int height, int scanlineStride, float pixelScale) {
        return new Image(PixelFormat.BYTE_RGB, pixels, width, height, 0, 0, scanlineStride, pixelScale);
    }

    public static Image fromByteGrayData(byte[] pixels, int width, int height) {
        return new Image(PixelFormat.BYTE_GRAY, pixels, width, height);
    }

    public static Image fromByteGrayData(ByteBuffer pixels, int width, int height) {
        return new Image(PixelFormat.BYTE_GRAY, pixels, width, height);
    }

    public static Image fromByteGrayData(ByteBuffer pixels, int width, int height, int scanlineStride) {
        return new Image(PixelFormat.BYTE_GRAY, pixels, width, height, 0, 0, scanlineStride);
    }

    public static Image fromByteGrayData(ByteBuffer pixels, int width, int height, int scanlineStride, float pixelScale) {
        return new Image(PixelFormat.BYTE_GRAY, pixels, width, height, 0, 0, scanlineStride, pixelScale);
    }

    public static Image fromByteAlphaData(byte[] pixels, int width, int height) {
        return new Image(PixelFormat.BYTE_ALPHA, pixels, width, height);
    }

    public static Image fromByteAlphaData(ByteBuffer pixels, int width, int height) {
        return new Image(PixelFormat.BYTE_ALPHA, pixels, width, height);
    }

    public static Image fromByteAlphaData(ByteBuffer pixels, int width, int height, int scanlineStride) {
        return new Image(PixelFormat.BYTE_ALPHA, pixels, width, height, 0, 0, scanlineStride);
    }

    public static Image fromByteApple422Data(byte[] pixels, int width, int height) {
        return new Image(PixelFormat.BYTE_APPLE_422, pixels, width, height);
    }

    public static Image fromByteApple422Data(ByteBuffer pixels, int width, int height) {
        return new Image(PixelFormat.BYTE_APPLE_422, pixels, width, height);
    }

    public static Image fromByteApple422Data(ByteBuffer pixels, int width, int height, int scanlineStride) {
        return new Image(PixelFormat.BYTE_APPLE_422, pixels, width, height, 0, 0, scanlineStride);
    }

    public static Image fromFloatMapData(FloatBuffer pixels, int width, int height) {
        return new Image(PixelFormat.FLOAT_XYZW, pixels, width, height);
    }

    public static Image convertImageFrame(ImageFrame frame) {
        ByteBuffer buffer = (ByteBuffer)frame.getImageData();
        ImageStorage.ImageType type = frame.getImageType();
        int w = frame.getWidth();
        int h = frame.getHeight();
        int scanBytes = frame.getStride();
        float ps = frame.getPixelScale();
        switch (type) {
            case GRAY: {
                return Image.fromByteGrayData(buffer, w, h, scanBytes, ps);
            }
            case RGB: {
                return Image.fromByteRgbData(buffer, w, h, scanBytes, ps);
            }
            case RGBA: {
                ByteBgra.ToByteBgraPreConverter().convert(buffer, 0, scanBytes, buffer, 0, scanBytes, w, h);
            }
            case RGBA_PRE: {
                ByteRgba.ToByteBgraConverter().convert(buffer, 0, scanBytes, buffer, 0, scanBytes, w, h);
                return Image.fromByteBgraPreData(buffer, w, h, scanBytes, ps);
            }
            case GRAY_ALPHA: {
                ByteGrayAlpha.ToByteGrayAlphaPreConverter().convert(buffer, 0, scanBytes, buffer, 0, scanBytes, w, h);
            }
            case GRAY_ALPHA_PRE: {
                if (scanBytes != w * 2) {
                    throw new AssertionError((Object)"Bad stride for GRAY_ALPHA");
                }
                byte[] newbuf = new byte[w * h * 4];
                ByteGrayAlphaPre.ToByteBgraPreConverter().convert(buffer, 0, scanBytes, newbuf, 0, w * 4, w, h);
                return Image.fromByteBgraPreData(newbuf, w, h, ps);
            }
        }
        throw new RuntimeException("Unknown image type: " + (Object)((Object)type));
    }

    private Image(PixelFormat pixelFormat, int[] pixels, int width, int height) {
        this(pixelFormat, IntBuffer.wrap(pixels), width, height, 0, 0, 0, 1.0f);
    }

    private Image(PixelFormat pixelFormat, byte[] pixels, int width, int height) {
        this(pixelFormat, ByteBuffer.wrap(pixels), width, height, 0, 0, 0, 1.0f);
    }

    private Image(PixelFormat pixelFormat, Buffer pixelBuffer, int width, int height) {
        this(pixelFormat, pixelBuffer, width, height, 0, 0, 0, 1.0f);
    }

    private Image(PixelFormat pixelFormat, Buffer pixelBuffer, int width, int height, int minX, int minY, int scanlineStride) {
        this(pixelFormat, pixelBuffer, width, height, minX, minY, scanlineStride, 1.0f);
    }

    private Image(PixelFormat pixelFormat, Buffer pixelBuffer, int width, int height, int minX, int minY, int scanlineStride, float pixelScale) {
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Format not supported " + pixelFormat.name());
        }
        if (scanlineStride == 0) {
            scanlineStride = width * pixelFormat.getBytesPerPixelUnit();
        }
        if (pixelBuffer == null) {
            throw new IllegalArgumentException("Pixel buffer must be non-null");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Image dimensions must be > 0");
        }
        if (minX < 0 || minY < 0) {
            throw new IllegalArgumentException("Image minX and minY must be >= 0");
        }
        if ((minX + width) * pixelFormat.getBytesPerPixelUnit() > scanlineStride) {
            throw new IllegalArgumentException("Image scanlineStride is too small");
        }
        if (scanlineStride % pixelFormat.getBytesPerPixelUnit() != 0) {
            throw new IllegalArgumentException("Image scanlineStride must be a multiple of the pixel stride");
        }
        this.pixelFormat = pixelFormat;
        this.pixelBuffer = pixelBuffer;
        this.width = width;
        this.height = height;
        this.minX = minX;
        this.minY = minY;
        this.scanlineStride = scanlineStride;
        this.pixelScale = pixelScale;
    }

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public PixelFormat.DataType getDataType() {
        return this.pixelFormat.getDataType();
    }

    public int getBytesPerPixelUnit() {
        return this.pixelFormat.getBytesPerPixelUnit();
    }

    public Buffer getPixelBuffer() {
        return this.pixelBuffer;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    @Override
    public float getPixelScale() {
        return this.pixelScale;
    }

    public int getRowLength() {
        return this.scanlineStride / this.pixelFormat.getBytesPerPixelUnit();
    }

    public boolean isTightlyPacked() {
        return this.minX == 0 && this.minY == 0 && this.width == this.getRowLength();
    }

    public Image createSubImage(int x, int y, int w, int h) {
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("Subimage dimensions must be > 0");
        }
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("Subimage minX and minY must be >= 0");
        }
        if (x + w > this.width) {
            throw new IllegalArgumentException("Subimage minX+width must be <= width of parent image");
        }
        if (y + h > this.height) {
            throw new IllegalArgumentException("Subimage minY+height must be <= height of parent image");
        }
        Image subimg = new Image(this.pixelFormat, this.pixelBuffer, w, h, this.minX + x, this.minY + y, this.scanlineStride);
        subimg.serial = this.serial;
        return subimg;
    }

    public Image createPackedCopy() {
        int newBytesPerRow = this.width * this.pixelFormat.getBytesPerPixelUnit();
        Buffer newBuf = Image.createPackedBuffer(this.pixelBuffer, this.pixelFormat, this.minX, this.minY, this.width, this.height, this.scanlineStride);
        return new Image(this.pixelFormat, newBuf, this.width, this.height, 0, 0, newBytesPerRow);
    }

    public Image createPackedCopyIfNeeded() {
        int newBytesPerRow = this.width * this.pixelFormat.getBytesPerPixelUnit();
        if (newBytesPerRow == this.scanlineStride && this.minX == 0 && this.minY == 0) {
            return this;
        }
        return this.createPackedCopy();
    }

    public static Buffer createPackedBuffer(Buffer pixels, PixelFormat format, int minX, int minY, int width, int height, int scanlineStride) {
        Buffer newBuf;
        if (scanlineStride % format.getBytesPerPixelUnit() != 0) {
            throw new IllegalArgumentException("Image scanlineStride must be a multiple of the pixel stride");
        }
        if (format == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Format unsupported " + (Object)((Object)format));
        }
        int elemsPerPixel = format.getElemsPerPixelUnit();
        int oldRowLength = scanlineStride / format.getBytesPerPixelUnit();
        int oldElemsPerRow = oldRowLength * elemsPerPixel;
        int newElemsPerRow = width * elemsPerPixel;
        int newSizeInElems = newElemsPerRow * height;
        int oldpos = minX * elemsPerPixel + minY * oldElemsPerRow;
        int newpos = 0;
        switch (format.getDataType()) {
            case BYTE: {
                ByteBuffer oldbbuf = (ByteBuffer)pixels;
                ByteBuffer newbbuf = BufferUtil.newByteBuffer(newSizeInElems);
                for (int y = 0; y < height; ++y) {
                    oldbbuf.limit(oldpos + newElemsPerRow);
                    oldbbuf.position(oldpos);
                    newbbuf.limit(newpos + newElemsPerRow);
                    newbbuf.position(newpos);
                    newbbuf.put(oldbbuf);
                    oldpos += oldElemsPerRow;
                    newpos += newElemsPerRow;
                }
                newBuf = newbbuf;
                break;
            }
            case INT: {
                IntBuffer oldibuf = (IntBuffer)pixels;
                IntBuffer newibuf = BufferUtil.newIntBuffer(newSizeInElems);
                for (int y = 0; y < height; ++y) {
                    oldibuf.limit(oldpos + newElemsPerRow);
                    oldibuf.position(oldpos);
                    newibuf.limit(newpos + newElemsPerRow);
                    newibuf.position(newpos);
                    newibuf.put(oldibuf);
                    oldpos += oldElemsPerRow;
                    newpos += newElemsPerRow;
                }
                newBuf = newibuf;
                break;
            }
            case FLOAT: {
                FloatBuffer oldfbuf = (FloatBuffer)pixels;
                FloatBuffer newfbuf = BufferUtil.newFloatBuffer(newSizeInElems);
                for (int y = 0; y < height; ++y) {
                    oldfbuf.limit(oldpos + newElemsPerRow);
                    oldfbuf.position(oldpos);
                    newfbuf.limit(newpos + newElemsPerRow);
                    newfbuf.position(newpos);
                    newfbuf.put(oldfbuf);
                    oldpos += oldElemsPerRow;
                    newpos += newElemsPerRow;
                }
                newBuf = newfbuf;
                break;
            }
            default: {
                throw new InternalError("Unknown data type");
            }
        }
        pixels.limit(pixels.capacity());
        pixels.rewind();
        newBuf.limit(newBuf.capacity());
        newBuf.rewind();
        return newBuf;
    }

    public Image iconify(ByteBuffer iconBuffer, int twidth, int theight) {
        if (this.pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Format not supported " + (Object)((Object)this.pixelFormat));
        }
        int tnumBands = this.getBytesPerPixelUnit();
        int tscanlineStride = twidth * tnumBands;
        ByteToIntPixelConverter converter = tnumBands == 1 ? ByteGray.ToIntArgbPreConverter() : (this.pixelFormat == PixelFormat.BYTE_BGRA_PRE ? ByteBgraPre.ToIntArgbPreConverter() : ByteRgb.ToIntArgbPreConverter());
        int[] newImage = new int[twidth * theight];
        converter.convert(iconBuffer, 0, tscanlineStride, newImage, 0, twidth, twidth, theight);
        return new Image(PixelFormat.INT_ARGB_PRE, newImage, twidth, theight);
    }

    public String toString() {
        return super.toString() + " [format=" + (Object)((Object)this.pixelFormat) + " width=" + this.width + " height=" + this.height + " scanlineStride=" + this.scanlineStride + " minX=" + this.minX + " minY=" + this.minY + " pixelBuffer=" + this.pixelBuffer + " bpp=" + this.getBytesPerPixelUnit() + "]";
    }

    public int getSerial() {
        return this.serial[0];
    }

    public Image promoteByteRgbToByteBgra() {
        ByteBuffer oldbuf = (ByteBuffer)this.pixelBuffer;
        ByteBuffer newbuf = ByteBuffer.allocate(this.width * this.height * 4);
        int oldpos = this.minY * this.scanlineStride + this.minX * 3;
        ByteRgb.ToByteBgraPreConverter().convert(oldbuf, oldpos, this.scanlineStride, newbuf, 0, this.width * 4, this.width, this.height);
        return new Image(PixelFormat.BYTE_BGRA_PRE, newbuf, this.width, this.height, 0, 0, this.width * 4, this.getPixelScale());
    }

    private Accessor<?> getPixelAccessor() {
        if (this.pixelaccessor == null) {
            switch (this.getPixelFormat()) {
                default: {
                    this.pixelaccessor = new UnsupportedAccess();
                    break;
                }
                case BYTE_GRAY: {
                    this.pixelaccessor = new ByteAccess(Image.getGrayFXPixelFormat(), ByteGray.getter, null, (ByteBuffer)this.pixelBuffer, 1);
                    break;
                }
                case BYTE_RGB: {
                    this.pixelaccessor = new ByteRgbAccess((ByteBuffer)this.pixelBuffer);
                    break;
                }
                case BYTE_BGRA_PRE: {
                    this.pixelaccessor = new ByteAccess(FX_ByteBgraPre_FORMAT, (ByteBuffer)this.pixelBuffer, 4);
                    break;
                }
                case INT_ARGB_PRE: {
                    this.pixelaccessor = new IntAccess(FX_IntArgbPre_FORMAT, (IntBuffer)this.pixelBuffer);
                }
            }
        }
        if (this.pixelaccessor != null && this.pixelScale != 1.0f) {
            this.pixelaccessor = new ScaledAccessor(this.pixelaccessor, this.pixelScale);
        }
        return this.pixelaccessor;
    }

    @Override
    public javafx.scene.image.PixelFormat<?> getPlatformPixelFormat() {
        return this.getPixelAccessor().getPlatformPixelFormat();
    }

    @Override
    public boolean isWritable() {
        return this.getPixelAccessor().isWritable();
    }

    @Override
    public PlatformImage promoteToWritableImage() {
        return this.getPixelAccessor().promoteToWritableImage();
    }

    @Override
    public int getArgb(int x, int y) {
        return this.getPixelAccessor().getArgb(x, y);
    }

    @Override
    public void setArgb(int x, int y, int argb) {
        this.getPixelAccessor().setArgb(x, y, argb);
        this.serial[0] = this.serial[0] + 1;
    }

    @Override
    public <T extends Buffer> void getPixels(int x, int y, int w, int h, WritablePixelFormat<T> pixelformat, T pixels, int scanlineBytes) {
        this.getPixelAccessor().getPixels(x, y, w, h, pixelformat, pixels, scanlineBytes);
    }

    @Override
    public void getPixels(int x, int y, int w, int h, WritablePixelFormat<ByteBuffer> pixelformat, byte[] pixels, int offset, int scanlineBytes) {
        this.getPixelAccessor().getPixels(x, y, w, h, pixelformat, pixels, offset, scanlineBytes);
    }

    @Override
    public void getPixels(int x, int y, int w, int h, WritablePixelFormat<IntBuffer> pixelformat, int[] pixels, int offset, int scanlineInts) {
        this.getPixelAccessor().getPixels(x, y, w, h, pixelformat, pixels, offset, scanlineInts);
    }

    @Override
    public <T extends Buffer> void setPixels(int x, int y, int w, int h, javafx.scene.image.PixelFormat<T> pixelformat, T pixels, int scanlineBytes) {
        this.getPixelAccessor().setPixels(x, y, w, h, pixelformat, pixels, scanlineBytes);
        this.serial[0] = this.serial[0] + 1;
    }

    @Override
    public void setPixels(int x, int y, int w, int h, javafx.scene.image.PixelFormat<ByteBuffer> pixelformat, byte[] pixels, int offset, int scanlineBytes) {
        this.getPixelAccessor().setPixels(x, y, w, h, pixelformat, pixels, offset, scanlineBytes);
        this.serial[0] = this.serial[0] + 1;
    }

    @Override
    public void setPixels(int x, int y, int w, int h, javafx.scene.image.PixelFormat<IntBuffer> pixelformat, int[] pixels, int offset, int scanlineInts) {
        this.getPixelAccessor().setPixels(x, y, w, h, pixelformat, pixels, offset, scanlineInts);
        this.serial[0] = this.serial[0] + 1;
    }

    @Override
    public void setPixels(int dstx, int dsty, int w, int h, PixelReader reader, int srcx, int srcy) {
        this.getPixelAccessor().setPixels(dstx, dsty, w, h, reader, srcx, srcy);
        this.serial[0] = this.serial[0] + 1;
    }

    public boolean isOpaque() {
        return this.pixelFormat.isOpaque();
    }

    static <I extends Buffer> PixelSetter<I> getSetterIfWritable(javafx.scene.image.PixelFormat<I> theFormat) {
        if (theFormat instanceof WritablePixelFormat) {
            return PixelUtils.getSetter((WritablePixelFormat)theFormat);
        }
        return null;
    }

    static javafx.scene.image.PixelFormat<ByteBuffer> getGrayFXPixelFormat() {
        if (FX_ByteGray_FORMAT == null) {
            int[] grays = new int[256];
            int gray = -16777216;
            for (int i = 0; i < 256; ++i) {
                grays[i] = gray;
                gray += 65793;
            }
            FX_ByteGray_FORMAT = javafx.scene.image.PixelFormat.createByteIndexedPremultipliedInstance(grays);
        }
        return FX_ByteGray_FORMAT;
    }

    class ByteRgbAccess
    extends ByteAccess {
        public ByteRgbAccess(ByteBuffer buffer) {
            super(FX_ByteRgb_FORMAT, buffer, 3);
        }

        @Override
        public PlatformImage promoteToWritableImage() {
            return Image.this.promoteByteRgbToByteBgra();
        }
    }

    class UnsupportedAccess
    extends ByteAccess {
        private UnsupportedAccess() {
            super(null, null, null, null, 0);
        }
    }

    class IntAccess
    extends BaseAccessor<IntBuffer> {
        IntAccess(javafx.scene.image.PixelFormat<IntBuffer> fmt, IntBuffer buffer) {
            super(Image.this, fmt, (Buffer)buffer, 1);
        }

        @Override
        public void getPixels(int x, int y, int w, int h, WritablePixelFormat<ByteBuffer> pixelformat, byte[] dstarr, int dstoff, int dstScanlineBytes) {
            BytePixelSetter setter = PixelUtils.getByteSetter(pixelformat);
            IntToBytePixelConverter i2bconverter = PixelUtils.getI2BConverter(this.getGetter(), setter);
            i2bconverter.convert((IntBuffer)this.getBuffer(), this.getIndex(x, y), this.scanlineElems, dstarr, dstoff, dstScanlineBytes, w, h);
        }

        @Override
        public void getPixels(int x, int y, int w, int h, WritablePixelFormat<IntBuffer> pixelformat, int[] dstarr, int dstoff, int dstScanlineInts) {
            IntPixelSetter setter = PixelUtils.getIntSetter(pixelformat);
            IntToIntPixelConverter i2iconverter = PixelUtils.getI2IConverter(this.getGetter(), setter);
            i2iconverter.convert((IntBuffer)this.getBuffer(), this.getIndex(x, y), this.scanlineElems, dstarr, dstoff, dstScanlineInts, w, h);
        }

        @Override
        public void setPixels(int x, int y, int w, int h, javafx.scene.image.PixelFormat<ByteBuffer> pixelformat, byte[] srcarr, int srcoff, int srcScanlineBytes) {
            BytePixelGetter getter = PixelUtils.getByteGetter(pixelformat);
            ByteToIntPixelConverter b2iconverter = PixelUtils.getB2IConverter(getter, this.getSetter());
            b2iconverter.convert(srcarr, srcoff, srcScanlineBytes, (IntBuffer)this.getBuffer(), this.getIndex(x, y), this.scanlineElems, w, h);
        }

        @Override
        public void setPixels(int x, int y, int w, int h, javafx.scene.image.PixelFormat<IntBuffer> pixelformat, int[] srcarr, int srcoff, int srcScanlineInts) {
            IntPixelGetter getter = PixelUtils.getIntGetter(pixelformat);
            IntToIntPixelConverter i2iconverter = PixelUtils.getI2IConverter(getter, this.getSetter());
            i2iconverter.convert(srcarr, srcoff, srcScanlineInts, (IntBuffer)this.getBuffer(), this.getIndex(x, y), this.scanlineElems, w, h);
        }

        @Override
        public void setPixels(int dstx, int dsty, int w, int h, PixelReader reader, int srcx, int srcy) {
            IntBuffer b = ((IntBuffer)this.theBuffer).duplicate();
            b.position(b.position() + this.getIndex(dstx, dsty));
            reader.getPixels(srcx, srcy, w, h, (WritablePixelFormat)this.theFormat, b, this.scanlineElems);
        }
    }

    class ByteAccess
    extends BaseAccessor<ByteBuffer> {
        ByteAccess(javafx.scene.image.PixelFormat<ByteBuffer> fmt, PixelGetter<ByteBuffer> getter, PixelSetter<ByteBuffer> setter, ByteBuffer buffer, int numbytes) {
            super(Image.this, fmt, getter, setter, (Buffer)buffer, numbytes);
        }

        ByteAccess(javafx.scene.image.PixelFormat<ByteBuffer> fmt, ByteBuffer buffer, int numbytes) {
            super(Image.this, fmt, (Buffer)buffer, numbytes);
        }

        @Override
        public void getPixels(int x, int y, int w, int h, WritablePixelFormat<ByteBuffer> pixelformat, byte[] dstarr, int dstoff, int dstScanlineBytes) {
            BytePixelSetter setter = PixelUtils.getByteSetter(pixelformat);
            ByteToBytePixelConverter b2bconverter = PixelUtils.getB2BConverter(this.getGetter(), setter);
            b2bconverter.convert((ByteBuffer)this.getBuffer(), this.getIndex(x, y), this.scanlineElems, dstarr, dstoff, dstScanlineBytes, w, h);
        }

        @Override
        public void getPixels(int x, int y, int w, int h, WritablePixelFormat<IntBuffer> pixelformat, int[] dstarr, int dstoff, int dstScanlineInts) {
            IntPixelSetter setter = PixelUtils.getIntSetter(pixelformat);
            ByteToIntPixelConverter b2iconverter = PixelUtils.getB2IConverter(this.getGetter(), setter);
            b2iconverter.convert((ByteBuffer)this.getBuffer(), this.getIndex(x, y), this.scanlineElems, dstarr, dstoff, dstScanlineInts, w, h);
        }

        @Override
        public void setPixels(int x, int y, int w, int h, javafx.scene.image.PixelFormat<ByteBuffer> pixelformat, byte[] srcarr, int srcoff, int srcScanlineBytes) {
            BytePixelGetter getter = PixelUtils.getByteGetter(pixelformat);
            ByteToBytePixelConverter b2bconverter = PixelUtils.getB2BConverter(getter, this.getSetter());
            b2bconverter.convert(srcarr, srcoff, srcScanlineBytes, (ByteBuffer)this.getBuffer(), this.getIndex(x, y), this.scanlineElems, w, h);
        }

        @Override
        public void setPixels(int x, int y, int w, int h, javafx.scene.image.PixelFormat<IntBuffer> pixelformat, int[] srcarr, int srcoff, int srcScanlineInts) {
            IntPixelGetter getter = PixelUtils.getIntGetter(pixelformat);
            IntToBytePixelConverter i2bconverter = PixelUtils.getI2BConverter(getter, this.getSetter());
            i2bconverter.convert(srcarr, srcoff, srcScanlineInts, (ByteBuffer)this.getBuffer(), this.getIndex(x, y), this.scanlineElems, w, h);
        }

        @Override
        public void setPixels(int dstx, int dsty, int w, int h, PixelReader reader, int srcx, int srcy) {
            ByteBuffer b = ((ByteBuffer)this.theBuffer).duplicate();
            b.position(b.position() + this.getIndex(dstx, dsty));
            reader.getPixels(srcx, srcy, w, h, (WritablePixelFormat)this.theFormat, b, this.scanlineElems);
        }
    }

    abstract class BaseAccessor<I extends Buffer>
    extends Accessor<I> {
        javafx.scene.image.PixelFormat<I> theFormat;
        PixelGetter<I> theGetter;
        PixelSetter<I> theSetter;
        I theBuffer;
        int pixelElems;
        int scanlineElems;
        int offsetElems;
        final /* synthetic */ Image this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        BaseAccessor(javafx.scene.image.PixelFormat<I> theFormat, I buffer, int pixelStride) {
            this((Image)this$0, theFormat, PixelUtils.getGetter(theFormat), Image.getSetterIfWritable(theFormat), (Buffer)buffer, pixelStride);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        BaseAccessor(javafx.scene.image.PixelFormat<I> theFormat, PixelGetter<I> getter, PixelSetter<I> setter, I buffer, int pixelStride) {
            this.this$0 = (Image)this$0;
            this.theFormat = theFormat;
            this.theGetter = getter;
            this.theSetter = setter;
            this.theBuffer = buffer;
            this.pixelElems = pixelStride;
            this.scanlineElems = ((Image)this$0).scanlineStride / ((Image)this$0).pixelFormat.getDataType().getSizeInBytes();
            this.offsetElems = ((Image)this$0).minY * this.scanlineElems + ((Image)this$0).minX * pixelStride;
        }

        public int getIndex(int x, int y) {
            if (x < 0 || y < 0 || x >= this.this$0.width || y >= this.this$0.height) {
                throw new IndexOutOfBoundsException(x + ", " + y);
            }
            return this.offsetElems + y * this.scanlineElems + x * this.pixelElems;
        }

        public I getBuffer() {
            return this.theBuffer;
        }

        public PixelGetter<I> getGetter() {
            if (this.theGetter == null) {
                throw new UnsupportedOperationException("Unsupported Image type");
            }
            return this.theGetter;
        }

        public PixelSetter<I> getSetter() {
            if (this.theSetter == null) {
                throw new UnsupportedOperationException("Unsupported Image type");
            }
            return this.theSetter;
        }

        @Override
        public javafx.scene.image.PixelFormat<I> getPlatformPixelFormat() {
            return this.theFormat;
        }

        @Override
        public boolean isWritable() {
            return this.theSetter != null;
        }

        @Override
        public PlatformImage promoteToWritableImage() {
            return this.this$0;
        }

        @Override
        public int getArgb(int x, int y) {
            return this.getGetter().getArgb(this.getBuffer(), this.getIndex(x, y));
        }

        @Override
        public void setArgb(int x, int y, int argb) {
            this.getSetter().setArgb(this.getBuffer(), this.getIndex(x, y), argb);
        }

        @Override
        public <T extends Buffer> void getPixels(int x, int y, int w, int h, WritablePixelFormat<T> pixelformat, T dstbuf, int dstScanlineElems) {
            PixelSetter<T> setter = PixelUtils.getSetter(pixelformat);
            PixelConverter<I, I> converter = PixelUtils.getConverter(this.getGetter(), setter);
            int dstoff = dstbuf.position();
            converter.convert(this.getBuffer(), this.getIndex(x, y), this.scanlineElems, dstbuf, dstoff, dstScanlineElems, w, h);
        }

        @Override
        public <T extends Buffer> void setPixels(int x, int y, int w, int h, javafx.scene.image.PixelFormat<T> pixelformat, T srcbuf, int srcScanlineBytes) {
            PixelGetter<T> getter = PixelUtils.getGetter(pixelformat);
            PixelConverter<T, I> converter = PixelUtils.getConverter(getter, this.getSetter());
            int srcoff = srcbuf.position();
            converter.convert(srcbuf, srcoff, srcScanlineBytes, this.getBuffer(), this.getIndex(x, y), this.scanlineElems, w, h);
        }
    }

    class ScaledAccessor<I extends Buffer>
    extends Accessor<I> {
        Accessor<I> theDelegate;
        float pixelScale;

        ScaledAccessor(Accessor<I> delegate, float pixelScale) {
            this.theDelegate = delegate;
            this.pixelScale = pixelScale;
        }

        private int scale(int v) {
            return (int)(((float)v + 0.5f) * this.pixelScale);
        }

        @Override
        public int getArgb(int x, int y) {
            return this.theDelegate.getArgb(this.scale(x), this.scale(y));
        }

        @Override
        public void setArgb(int x, int y, int argb) {
            throw new UnsupportedOperationException("Pixel setting for scaled images not supported yet");
        }

        @Override
        public javafx.scene.image.PixelFormat<I> getPlatformPixelFormat() {
            return this.theDelegate.getPlatformPixelFormat();
        }

        @Override
        public boolean isWritable() {
            return this.theDelegate.isWritable();
        }

        @Override
        public PlatformImage promoteToWritableImage() {
            throw new UnsupportedOperationException("Pixel setting for scaled images not supported yet");
        }

        @Override
        public <T extends Buffer> void getPixels(int x, int y, int w, int h, WritablePixelFormat<T> pixelformat, T pixels, int scanlineElems) {
            PixelSetter<T> setter = PixelUtils.getSetter(pixelformat);
            int offset = pixels.position();
            int numElem = setter.getNumElements();
            for (int rely = 0; rely < h; ++rely) {
                int sy = this.scale(y + rely);
                int rowoff = offset;
                for (int relx = 0; relx < w; ++relx) {
                    int sx = this.scale(x + relx);
                    setter.setArgb(pixels, rowoff, this.theDelegate.getArgb(sx, sy));
                    rowoff += numElem;
                }
                offset += scanlineElems;
            }
        }

        @Override
        public void getPixels(int x, int y, int w, int h, WritablePixelFormat<ByteBuffer> pixelformat, byte[] pixels, int offset, int scanlineBytes) {
            ByteBuffer bb = ByteBuffer.wrap(pixels);
            bb.position(offset);
            this.getPixels(x, y, w, h, pixelformat, bb, scanlineBytes);
        }

        @Override
        public void getPixels(int x, int y, int w, int h, WritablePixelFormat<IntBuffer> pixelformat, int[] pixels, int offset, int scanlineInts) {
            IntBuffer ib = IntBuffer.wrap(pixels);
            ib.position(offset);
            this.getPixels(x, y, w, h, pixelformat, ib, scanlineInts);
        }

        @Override
        public <T extends Buffer> void setPixels(int x, int y, int w, int h, javafx.scene.image.PixelFormat<T> pixelformat, T pixels, int scanlineElems) {
            throw new UnsupportedOperationException("Pixel setting for scaled images not supported yet");
        }

        @Override
        public void setPixels(int x, int y, int w, int h, javafx.scene.image.PixelFormat<ByteBuffer> pixelformat, byte[] pixels, int offset, int scanlineBytes) {
            throw new UnsupportedOperationException("Pixel setting for scaled images not supported yet");
        }

        @Override
        public void setPixels(int x, int y, int w, int h, javafx.scene.image.PixelFormat<IntBuffer> pixelformat, int[] pixels, int offset, int scanlineInts) {
            throw new UnsupportedOperationException("Pixel setting for scaled images not supported yet");
        }

        @Override
        public void setPixels(int dstx, int dsty, int w, int h, PixelReader reader, int srcx, int srcy) {
            throw new UnsupportedOperationException("Pixel setting for scaled images not supported yet");
        }
    }

    abstract class Accessor<I extends Buffer> {
        Accessor() {
        }

        public abstract int getArgb(int var1, int var2);

        public abstract void setArgb(int var1, int var2, int var3);

        public abstract javafx.scene.image.PixelFormat<I> getPlatformPixelFormat();

        public abstract boolean isWritable();

        public abstract PlatformImage promoteToWritableImage();

        public abstract <T extends Buffer> void getPixels(int var1, int var2, int var3, int var4, WritablePixelFormat<T> var5, T var6, int var7);

        public abstract void getPixels(int var1, int var2, int var3, int var4, WritablePixelFormat<ByteBuffer> var5, byte[] var6, int var7, int var8);

        public abstract void getPixels(int var1, int var2, int var3, int var4, WritablePixelFormat<IntBuffer> var5, int[] var6, int var7, int var8);

        public abstract <T extends Buffer> void setPixels(int var1, int var2, int var3, int var4, javafx.scene.image.PixelFormat<T> var5, T var6, int var7);

        public abstract void setPixels(int var1, int var2, int var3, int var4, javafx.scene.image.PixelFormat<ByteBuffer> var5, byte[] var6, int var7, int var8);

        public abstract void setPixels(int var1, int var2, int var3, int var4, javafx.scene.image.PixelFormat<IntBuffer> var5, int[] var6, int var7, int var8);

        public abstract void setPixels(int var1, int var2, int var3, int var4, PixelReader var5, int var6, int var7);
    }
}

