var highchartsColors=['#4572A7','#AA4643','#89A54E','#80699B','#3D96AE','#DB843D','#92A8CD','#A47D7C','#B5CA92'];

(function() {
	window.jtekma={};
	
	
})();

$(document).ready(function() {
	$("[rel='tooltip']").tooltip();
	
	$(".deleteConfirmationButton").on("click",function(event) {
		event.preventDefault();
		var href=$(this).attr("href");
		var dialogTitle=$(this).attr("dialog-title");
		var dialogMessage=$(this).attr("dialog-message");
		dialog.showConfirmationRedirect(dialogTitle,dialogMessage,href);
		return false;
	});
	
	$(".chosen-select").each(function(index) {
		var width=$(this).attr("width");
		var options={
			"search_contains":true
		};
		if (width) {
			options.width=width;
		}
		$(this).chosen(options);
	});
	
	$(".color-picker").each(function(index) {
		var field=this;
		var color="#FFFFFF";
		
		if ($(field).prop("tagName")=="INPUT") {
			if ($(field).val()!="") {
				color=$(field).val();
			}
			$(field).ColorPicker({
				"color":color,
				onChange:function(hsb, hex, rgb, el) {
					$(field).val(hex);
				}
			});
		}
		else {
			var rgb=$(field).css("background-color");
			if (rgb!="transparent") {
				rgb=rgb.substring(4,rgb.length-1).replace(/\s/g,"").split(",");
				color="#";
				for (var i=0;i<3;i++) {
					if (Number(rgb[i])<10) {
						color+="0";
					}
					color+=Number(rgb[i]).toString(16);
				}
			}
			$(field).ColorPicker({
				"color":color,
				onChange:function(hsb, hex, rgb, el) {
					$(field).css('backgroundColor', '#' + hex);
				}
			});
		}
	});

	$("input.date").each(function(index) {
		var dateFormat=$(this).attr("date-format");
		if (!dateFormat) {
			dateFormat=defaultDateFormat;
		}
		$(this).datepicker({
			"dateFormat":dateFormat
		});
	});
	
	$("input.datetime").each(function(index) {
		var dateFormat=$(this).attr("date-format");
		var timeFormat=$(this).attr("time-format");
		if (!dateFormat) {
			dateFormat=defaultDateFormat;
		}
		if (!timeFormat) {
			timeFormat=defaultTimeFormat;
		}
		$(this).datetimepicker({
			"dateFormat":dateFormat,
			"timeFormat":timeFormat
		});
	});
	
	$("input.time").each(function(index) {
		var timeFormat=$(this).attr("time-format");
		if (!timeFormat) {
			timeFormat=defaultTimeFormat;
		}
		$(this).timepicker({
			"timeFormat":timeFormat
		});
	});

	$("[slider-for]").each(function(index) {
		var sliderField=this;
		var forInputName=$(sliderField).attr("slider-for");
		var forInput=$(sliderField).parent().find("input[name='"+forInputName+"']");
		var min=Number($(sliderField).attr("min"));
		var max=Number($(sliderField).attr("max"));
		var step=Number($(sliderField).attr("step"));

		if (String(min)=="NaN") {
			min=0;
		}
		if (String(max)=="NaN") {
			max=100;
		}
		if (String(step)=="NaN") {
			step=1;
		}

		$(sliderField).slider({
			"min":min,
			"max":max,
			"step":step,
			"value":$(forInput).val(),
			"change":function(event,ui) {
				forInput.val(ui.value);
			},
			"slide":function(event,ui) {
				forInput.val(ui.value);
			}
		});

		forInput.on("change",function() {
			var value=Number($(this).val());
			if ($(this).val()=="" || String(value)=="NaN") {
				$(this).val("0");
			}
			if (value<min) {
				value=min;
			}
			if (value>max) {
				value=max;
			}
			$(sliderField).slider("value",value);
		});
		forInput.on("keyup",function() {
			var value=Number($(this).val());
			if ($(this).val()!="" && String(value)!="NaN") {
				if (value>=min && value<=max) {
					$(sliderField).slider("value",value);
				}
			}
		});
	});

	$("input.spinner").each(function(index) {
		var min=Number($(this).attr("min"));
		var max=Number($(this).attr("max"));
		var step=Number($(this).attr("step"));
		var numberFormat=$(this).attr("number-format");

		if (String(min)=="NaN") {
			min=0;
		}
		if (String(max)=="NaN") {
			max=100;
		}
		if (String(step)=="NaN") {
			step=1;
		}
		if (!numberFormat) {
			numberFormat="n";
		}

		$(this).spinner({
			"min":min,
			"max":max,
			"step":step,
			"numberFormat":numberFormat
		});
	});
	
	$("#search").change(function(e) {
		e.preventDefault();
		$("#page").val("1");
		$("#page").parent().submit();
		return false;
	});
	
	$("#showPerPage").change(function(e) {
		e.preventDefault();
		$("#page").val("1");
		$("#page").parent().submit();
		return false;
	});
	
	$("ul.pagination a").on("click",function(event) {
		var selectedPageNum=$(this).attr("href").substring(1);
		var currentPageNum=Number($("#page").val());
		if (selectedPageNum=="prev") {
			currentPageNum-=1;
			if (currentPageNum<1) {
				currentPageNum=1;
			}
		}
		else if (selectedPageNum=="next") {
			currentPageNum+=1;
		}
		else {
			currentPageNum=Number(selectedPageNum);
		}
		$("#page").val(String(currentPageNum));
		
		$("#page").parent().submit();
		
		return false;
	});
});
var DialogButton = Backbone.Model.extend({
	defaults: {
		"text":"",
		"click":null,
		"class": "btn btn-primary",
		"close":false
	},
	initialize:function() {
		
	}
});

var DialogButtonList = Backbone.Collection.extend({
	model: DialogButton
});

var DialogData = Backbone.Model.extend({
	defaults: {
		"type":"info",
		"title":"",
		"content":""
	},
	initialize:function() {
		this.set({buttons:new DialogButtonList()},{silent:true});
	}
});

var DialogButtonView = Backbone.View.extend({
	'tagName':"button",
	'initialize': function() {
		
		
	},
	'render': function() {
		var obj=this;
		this.$el.text(this.model.get("text"));
		this.$el.attr("type","button");
		this.$el.attr("class",this.model.get("class"));
		
		if (this.model.get("close")) {
			this.$el.attr("data-dismiss","modal");
		}
		
		this.$el.on("click",function() {
			var func=obj.model.get("click");
			if (func!=null) {
				func();
			}
		});
		
		return this;
	}
});

var DialogView = Backbone.View.extend({
	'tagName':"div",
	'template': "",
	'initialize': function() {
		this.template=templates.getDialogTemplate();
		this.$el.attr("class","modal fade");
	},
	show:function() {
		var obj=this;
		
		$("body").append(this.el);
		
		this.$el.modal({
	    	show:false
	    });
	    
		this.$el.on("hidden.bs.modal",function () {
			obj.$el.remove();
		});
		
		this.render();
		this.$el.modal("show");
	},
	hide: function() {
		
	},
	'render': function() {
		var obj=this;
		var data={
			title:obj.model.get("title")
		};
		this.$el.html(Mustache.render(this.template,data));
		this.$el.find("div.dialogContent").html(this.model.get("content"));
		
		//add buttons
		for (var i=0;i<this.model.get("buttons").length;i++) {
			var button=this.model.get("buttons").at(i);
			var dialogButtonView=new DialogButtonView({ model: button });
			this.$el.find(".modal-footer").append(dialogButtonView.render().el);
		}
		
		return this;
	}
});

var dialog={
	showDialog: function(title,content,buttons,openFunction) {
		var dialogData=new DialogData({
			type:"info",
			title:title,
			content:content
		});
		for (var i=0;i<buttons.length;i++) {
			var button=buttons[i];
			dialogData.get("buttons").add(new DialogButton({
				"text":button.text,
				"class":button.class,
				"close":button.close,
				"click":button.click
			}));
		}
		
		var dialogView=new DialogView({
			model:dialogData
		});
		
		if (openFunction) {
			$(dialogView.el).on("show",function () {
				openFunction(dialogView.el);
			});
		}
		
		dialogView.show();
		
		return dialogView.el;
	},
	showInfoMessage: function(message,title) {
		var dialogTitle=getSpringMessage("common.title.info");
		if (title) {
			dialogTitle=title;
		}
		
		var dialogData=new DialogData({
			type:"info",
			title:dialogTitle,
			content:message
		});
		
		var dialogView=new DialogView({
			model:dialogData
		});
		
		dialogData.get("buttons").add(new DialogButton({
			"text":getSpringMessage("common.close"),
			"class":"btn btn-primary",
			"close":true
		}));
		
		dialogView.show();
	},
	showErrorMessage: function(message) {
		var dialogTitle=getSpringMessage("common.title.error");
		if (title) {
			dialogTitle=title;
		}
		
		var dialogData=new DialogData({
			type:"info",
			title:dialogTitle,
			content:message
		});
		
		var dialogView=new DialogView({
			model:dialogData
		});
		
		dialogData.get("buttons").add(new DialogButton({
			"text":getSpringMessage("common.close"),
			"class":"btn btn-primary",
			"close":true
		}));
		
		dialogView.show();
	},
	showPopup: function(item,title,content) {
		$(item).popover({
			trigger:"hover",
			title:title,
			content:content
		});
		$(item).popover('show');
	},
	showConfirmation: function(title,text,confirmationAction) {
		var dialogData=new DialogData({
			type:"info",
			title:title,
			content:text
		});
		
		var dialogView=new DialogView({
			model:dialogData
		});
		
		dialogData.get("buttons").add(new DialogButton({
			"text":getSpringMessage("common.confirm"),
			"class":"btn btn-primary",
			"close":false,
			"click":function() {
				$(dialogView.el).modal("hide");
				confirmationAction();
			}
		}));
		
		dialogData.get("buttons").add(new DialogButton({
			"text":getSpringMessage("common.cancel"),
			"class":"btn btn-danger",
			"close":true
		}));
		
		dialogView.show();
	},
	showConfirmationRedirect: function(title,text,url) {
		dialog.showConfirmation(title,text,function() {
			window.location=url;
		});
	}
};
$(document).ready(function() {
	$(".pagination a").on("click",function(event) {
		event.preventDefault();
		
		var formId=$(this).parent().parent().attr("formId");
		if ($(this).attr("href")!=undefined) {
			var page=$(this).attr("href").substring(1);
			
			var currentPage=Number($("#"+formId+" input[name='page']").val());
			
			if (page=="prev") {
				currentPage-=1;
			}
			else if (page=="next") {
				currentPage+=1;
			}
			else {
				currentPage=Number(page);
			}
			$("#"+formId+" input[name='page']").val(currentPage);
			$("#"+formId).submit();
		}
	});
	
	$(".pagination input").on("change",function(event) {
		var formId=$(this).parent().parent().attr("formId");
		$("#"+formId+" input[name='page']").val($(this).val());
		$("#"+formId).submit();
	});
});var templates={
	dialogTemplate:"",
	getDialogTemplate:function () {
		if (this.dialogTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/templates/dialog",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.dialogTemplate=template;
		}
		return this.dialogTemplate;
	},
	competitionTemplate:"",
	getCompetitionTemplate:function() {
		if (this.competitionTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/competition",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionTemplate=template;
		}
		return this.competitionTemplate;
	},
	competitionDrawTemplate:"",
	getCompetitionDrawTemplate:function() {
		if (this.competitionDrawTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/draw",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionDrawTemplate=template;
		}
		return this.competitionDrawTemplate;
	},
	competitionTreeTemplate:"",
	getCompetitionTreeTemplate:function() {
		if (this.competitionTreeTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/tree",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionTreeTemplate=template;
		}
		return this.competitionTreeTemplate;
	},
	competitionTableTemplate:"",
	getCompetitionTableTemplate:function() {
		if (this.competitionTableTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/table",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionTableTemplate=template;
		}
		return this.competitionTableTemplate;
	},
	competitionMatchesTemplate:"",
	getCompetitionMatchesTemplate:function() {
		if (this.competitionMatchesTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/matches",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionMatchesTemplate=template;
		}
		return this.competitionMatchesTemplate;
	},
	competitionCustomMatchesTemplate:"",
	getCompetitionCustomMatchesTemplate:function() {
		if (this.competitionCustomMatchesTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/custom-matches",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionCustomMatchesTemplate=template;
		}
		return this.competitionCustomMatchesTemplate;
	},
	competitionMatchTemplate:"",
	getCompetitionMatchTemplate:function() {
		if (this.competitionMatchTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/match",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionMatchTemplate=template;
		}
		return this.competitionMatchTemplate;
	},
	competitionEditMatchFightTemplate:"",
	getCompetitionEditMatchFightTemplate:function() {
		if (this.competitionEditMatchFightTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/edit-match-fight",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionEditMatchFightTemplate=template;
		}
		return this.competitionEditMatchFightTemplate;
	},
	competitionEditMatchDuoTemplate:"",
	getCompetitionEditMatchDuoTemplate:function() {
		if (this.competitionEditMatchDuoTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/edit-match-duo",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionEditMatchDuoTemplate=template;
		}
		return this.competitionEditMatchDuoTemplate;
	},
	competitionEditMatchNewazaTemplate:"",
	getCompetitionEditMatchNewazaTemplate:function() {
		if (this.competitionEditMatchNewazaTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/edit-match-newaza",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionEditMatchNewazaTemplate=template;
		}
		return this.competitionEditMatchNewazaTemplate;
	},
	competitionAddMatchTemplate:"",
	getCompetitionAddMatchTemplate:function() {
		if (this.competitionAddMatchTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/add-match",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionAddMatchTemplate=template;
		}
		return this.competitionAddMatchTemplate;
	},
	competitionPlacingsTemplate:"",
	getCompetitionPlacingsTemplate:function() {
		if (this.competitionPlacingsTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/placings",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionPlacingsTemplate=template;
		}
		return this.competitionPlacingsTemplate;
	},
	competitionTatamiFightTemplate:"",
	getCompetitionTatamiFightTemplate:function() {
		if (this.competitionTatamiFightTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/tatami-fight",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionTatamiFightTemplate=template;
		}
		return this.competitionTatamiFightTemplate;
	},
	competitionTatamiHistoryEventTemplate:"",
	getCompetitionTatamiHistoryEventTemplate:function() {
		if (this.competitionTatamiHistoryEventTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/tatami-history-event",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionTatamiHistoryEventTemplate=template;
		}
		return this.competitionTatamiHistoryEventTemplate;
	},
	competitionEditEventTemplate:"",
	getCompetitionEditEventTemplate:function() {
		if (this.competitionEditEventTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/edit-event",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionEditEventTemplate=template;
		}
		return this.competitionEditEventTemplate;
	},
	competitionMatchDetailsTemplate:"",
	getCompetitionMatchDetailsTemplate:function() {
		if (this.competitionMatchDetailsTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/competition/template/match-details",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.competitionMatchDetailsTemplate=template;
		}
		return this.competitionMatchDetailsTemplate;
	},
	categoriesForAutomationTemplate:"",
	getCategoriesForAutomationTemplate:function() {
		if (this.categoriesForAutomationTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/automation/template/categories-for-automation",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.categoriesForAutomationTemplate=template;
		}
		return this.categoriesForAutomationTemplate;
	},
	categoriesForAddingTemplate:"",
	getCategoriesForAddingTemplate:function() {
		if (this.categoriesForAddingTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/automation/template/categories-for-adding",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.categoriesForAddingTemplate=template;
		}
		return this.categoriesForAddingTemplate;
	},
	weighingSearchTemplate:"",
	getWeighingSearchTemplate:function() {
		if (this.weighingSearchTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/weighing/template/search",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.weighingSearchTemplate=template;
		}
		return this.weighingSearchTemplate;
	},
	weighingCompetitorsTemplate:"",
	getWeighingCompetitorsTemplate:function() {
		if (this.weighingCompetitorsTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/weighing/template/competitors",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.weighingCompetitorsTemplate=template;
		}
		return this.weighingCompetitorsTemplate;
	},
	weighingCompetitorRowTemplate:"",
	getWeighingCompetitorRowTemplate:function() {
		if (this.weighingCompetitorRowTemplate=="") {
			var template="";
			$.ajax({
				async:false,
				url:contextPath+"/weighing/template/competitor-row",
				type: 'GET',
				success: function(responseData){
					template=responseData;
				}
			});
			this.weighingCompetitorRowTemplate=template;
		}
		return this.weighingCompetitorRowTemplate;
	}
};