/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.util.Collection;
import java.util.List;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static boolean isEmpty(Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtil.isEmpty(collection);
    }

    public static boolean contains(Collection<?> collection, Object value) {
        if (collection == null) {
            return false;
        }
        return collection.contains(value);
    }

    public static String toListString(List<?> list) {
        if (list == null) {
            return "null";
        }
        StringBuilder text = new StringBuilder();
        text.append("[");
        int c = 0;
        for (Object value : list) {
            if (c > 0) {
                text.append(", ");
            }
            text.append(c);
            ++c;
            text.append(":");
            if (value == null) {
                text.append("null");
                continue;
            }
            text.append(value.toString());
        }
        text.append("]");
        return text.toString();
    }

    public static String toCollectionString(Collection<?> set) {
        if (set == null) {
            return "null";
        }
        StringBuilder text = new StringBuilder();
        text.append("[");
        boolean firstItem = true;
        for (Object value : set) {
            if (firstItem) {
                firstItem = false;
            } else {
                text.append(", ");
            }
            if (value == null) {
                text.append("null");
                continue;
            }
            text.append(value.toString());
        }
        text.append("]");
        return text.toString();
    }

    public static boolean equalBasedOnItems(Collection<?> collection1, Collection<?> collection2) {
        if (collection1 == collection2) {
            return true;
        }
        if (collection1 == null) {
            return false;
        }
        if (collection2 == null) {
            return false;
        }
        if (collection1.size() != collection2.size()) {
            return false;
        }
        for (Object value : collection1) {
            if (collection2.contains(value)) continue;
            return false;
        }
        return true;
    }
}

