/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarGenerator {
    private Calendar calendar;

    public CalendarGenerator() {
        this.calendar = Calendar.getInstance();
    }

    public CalendarGenerator(Calendar calendar) {
        this.calendar = calendar;
    }

    public CalendarGenerator(Date date) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(date);
    }

    public CalendarGenerator(long timestamp) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeInMillis(timestamp);
    }

    public CalendarGenerator(Instant instant) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeInMillis(instant.toEpochMilli());
    }

    public CalendarGenerator withTimeZone(TimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
        return this;
    }

    public CalendarGenerator withTimeZone(String timeZone) {
        return this.withTimeZone(TimeZone.getTimeZone(timeZone));
    }

    public CalendarGenerator withTimeZoneUTC() {
        return this.withTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public CalendarGenerator withTimeZoneDefault() {
        return this.withTimeZone(TimeZone.getDefault());
    }

    public CalendarGenerator withWeekStartsAt(int firstDayOfWeek) {
        this.calendar.setFirstDayOfWeek(firstDayOfWeek);
        return this;
    }

    public CalendarGenerator atTime(int hours, int minutes, int seconds) {
        return this.atTime(hours, minutes, seconds, 0);
    }

    public CalendarGenerator atHourOfDay(int hourOfDay) {
        this.calendar.set(11, hourOfDay);
        return this;
    }

    public CalendarGenerator atMinute(int minutes) {
        this.calendar.set(12, minutes);
        return this;
    }

    public CalendarGenerator atSecond(int seconds) {
        this.calendar.set(13, seconds);
        return this;
    }

    public CalendarGenerator atMillisecond(int milliseconds) {
        this.calendar.set(14, milliseconds);
        return this;
    }

    public CalendarGenerator atTime(int hours, int minutes, int seconds, int milliseconds) {
        this.calendar.set(11, hours);
        this.calendar.set(12, minutes);
        this.calendar.set(13, seconds);
        this.calendar.set(14, milliseconds);
        return this;
    }

    public CalendarGenerator atDate(int year, int month, int day) {
        this.calendar.set(1, year);
        this.calendar.set(2, month - 1);
        this.calendar.set(5, day);
        return this;
    }

    public CalendarGenerator atYear(int year) {
        this.calendar.set(1, year);
        return this;
    }

    public CalendarGenerator atMonth(int month) {
        this.calendar.set(2, month - 1);
        return this;
    }

    public CalendarGenerator atWeek(int week) {
        this.calendar.set(3, week);
        return this;
    }

    public CalendarGenerator atDayOfMonth(int dayOfMonth) {
        this.calendar.set(5, dayOfMonth);
        return this;
    }

    public CalendarGenerator atStartOfDay() {
        return this.atTime(0, 0, 0);
    }

    public CalendarGenerator atEndOfDay() {
        this.atTime(23, 59, 0, 999);
        this.calendar.set(13, this.calendar.getActualMaximum(13));
        return this;
    }

    public CalendarGenerator atNoon() {
        return this.atTime(12, 0, 0);
    }

    public CalendarGenerator atStartOfMonth() {
        this.calendar.set(5, 1);
        return this;
    }

    public CalendarGenerator atEndOfMonth() {
        this.calendar.set(5, this.calendar.getActualMaximum(5));
        return this;
    }

    public CalendarGenerator atStartOfWeek() {
        this.calendar.set(7, this.calendar.getActualMinimum(7));
        return this;
    }

    public CalendarGenerator atEndOfWeek() {
        this.calendar.set(7, this.calendar.getActualMaximum(7));
        return this;
    }

    public CalendarGenerator addMilliseconds(int milliseconds) {
        this.calendar.add(14, milliseconds);
        return this;
    }

    public CalendarGenerator addSeconds(int seconds) {
        this.calendar.add(13, seconds);
        return this;
    }

    public CalendarGenerator addMinutes(int minutes) {
        this.calendar.add(12, minutes);
        return this;
    }

    public CalendarGenerator addHours(int hours) {
        this.calendar.add(11, hours);
        return this;
    }

    public CalendarGenerator addDays(int days) {
        this.calendar.add(6, days);
        return this;
    }

    public CalendarGenerator addWeek(int weeks) {
        this.calendar.add(3, weeks);
        return this;
    }

    public CalendarGenerator addMonths(int months) {
        this.calendar.add(2, months);
        return this;
    }

    public CalendarGenerator addYears(int years) {
        this.calendar.add(1, years);
        return this;
    }

    public CalendarGenerator atNextSecond() {
        return this.addSeconds(1);
    }

    public CalendarGenerator atPreviousSecond() {
        return this.addSeconds(-1);
    }

    public CalendarGenerator atNextMinute() {
        return this.addMinutes(1);
    }

    public CalendarGenerator atPreviousMinute() {
        return this.addMinutes(-1);
    }

    public CalendarGenerator atNextHour() {
        return this.addHours(1);
    }

    public CalendarGenerator atPreviousHour() {
        return this.addHours(-1);
    }

    public CalendarGenerator atNextDay() {
        return this.addDays(1);
    }

    public CalendarGenerator atPreviousDay() {
        return this.addDays(-1);
    }

    public CalendarGenerator atTomorrow() {
        return this.addDays(1);
    }

    public CalendarGenerator atYesterday() {
        return this.addDays(-1);
    }

    public CalendarGenerator atNextWeek() {
        return this.addWeek(1);
    }

    public CalendarGenerator atPreviousWeek() {
        return this.addWeek(-1);
    }

    public CalendarGenerator atNextMonth() {
        return this.addMonths(1);
    }

    public CalendarGenerator atPreviousMonth() {
        return this.addMonths(-1);
    }

    public CalendarGenerator atNextYear() {
        return this.addYears(1);
    }

    public CalendarGenerator atPreviousYear() {
        return this.addYears(-1);
    }

    public Calendar generate() {
        return this.calendar;
    }
}

