/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.servlet.security;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.web.servlet.security.AdditionalSecurityProvider;
import si.nevensrok.common.web.servlet.security.NumericSecurityCodeGenerator;
import si.nevensrok.common.web.servlet.security.SecurityCodeGenerator;
import si.nevensrok.common.web.servlet.security.SecurityCodeMessageSender;

public class MessageSecurityProvider
implements AdditionalSecurityProvider,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageSecurityProvider.class);
    private boolean optionalStep = true;
    private SecurityCodeMessageSender securityCodeMessageSender;
    private SecurityCodeGenerator securityCodeGenerator;
    private Map<Object, String> codes = new HashMap<Object, String>();
    private Map<Object, Date> codeValidUntil = new HashMap<Object, Date>();

    public void setOptionalStep(boolean optionalStep) {
        this.optionalStep = optionalStep;
    }

    public void setSecurityCodeMessageSender(SecurityCodeMessageSender securityCodeMessageSender) {
        this.securityCodeMessageSender = securityCodeMessageSender;
    }

    public void setSecurityCodeGenerator(SecurityCodeGenerator securityCodeGenerator) {
        this.securityCodeGenerator = securityCodeGenerator;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.securityCodeMessageSender == null) {
            throw new IllegalArgumentException("Property 'securityCodeMessageSender' is required");
        }
        if (this.securityCodeGenerator == null) {
            this.securityCodeGenerator = new NumericSecurityCodeGenerator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSecurityCodeToUser(Object principal) {
        block11: {
            try {
                boolean sendCode;
                this.checkIfCodeIsStillValid(principal);
                Map<Object, String> map = this.codes;
                synchronized (map) {
                    sendCode = !this.codes.containsKey(principal);
                }
                if (!sendCode) break block11;
                String code = this.securityCodeGenerator.generateSecurityCode();
                Map<Object, String> map2 = this.codes;
                synchronized (map2) {
                    this.codes.put(principal, code);
                }
                Calendar calendar = Calendar.getInstance();
                calendar.add(12, 15);
                Map<Object, Date> map3 = this.codeValidUntil;
                synchronized (map3) {
                    this.codeValidUntil.put(principal, calendar.getTime());
                }
                this.securityCodeMessageSender.sendSecurityCode(principal, code);
            }
            catch (Exception e) {
                LOGGER.error("Error sending security code", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isSecurityCheckNeeded(Object principal) {
        if (!this.optionalStep) {
            return true;
        }
        return this.securityCodeMessageSender.canSendMessage(principal);
    }

    @Override
    public void invalidSecurityCodeEntered(Object principal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkSecurityCode(Object principal, String securityCode) {
        try {
            String code;
            this.checkIfCodeIsStillValid(principal);
            Map<Object, String> map = this.codes;
            synchronized (map) {
                code = this.codes.get(principal);
            }
            if (code == null) {
                return false;
            }
            if (code.equals(securityCode)) {
                map = this.codes;
                synchronized (map) {
                    this.codes.remove(principal);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error chekcing security code", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfCodeIsStillValid(Object principal) {
        Date validUntil;
        Map<Object, Object> map = this.codeValidUntil;
        synchronized (map) {
            validUntil = this.codeValidUntil.get(principal);
        }
        if (validUntil == null || validUntil.getTime() < System.currentTimeMillis()) {
            map = this.codes;
            synchronized (map) {
                this.codes.remove(principal);
            }
        }
    }
}

