/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dto.rules;

import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import si.nevensrok.common.dl.CollectionType;
import si.nevensrok.common.dl.Dto;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.server.dl.dto.competition.CompetitionDTO;
import si.nevensrok.jtekma.server.dl.dto.rules.TreeAdvancmentItemDTO;

@Entity
@Table(name="treeadvancments")
public class TreeAdvancmentDTO
implements Dto<Long> {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="TREEADVANCMENTID_SEQ")
    @SequenceGenerator(name="TREEADVANCMENTID_SEQ", sequenceName="treeadvancmentidseq", allocationSize=0)
    @Column(name="treeadvancmentid", nullable=false)
    private Long treeAdvancmentId;
    @Column(length=100, name="name", nullable=false)
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="competitionid", nullable=true, updatable=false)
    private CompetitionDTO competition;
    @CollectionType(value=TreeAdvancmentItemDTO.class)
    @OneToMany(mappedBy="treeAdvancment", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<TreeAdvancmentItemDTO> treeAdvancmentItems;
    @Enumerated(value=EnumType.STRING)
    @Column(length=32, name="status", nullable=false)
    private TreeAdvancment.Status status;

    public Long getId() {
        return this.getTreeAdvancmentId();
    }

    public void setId(Long id) {
        this.setTreeAdvancmentId(id);
    }

    public Long getTreeAdvancmentId() {
        return this.treeAdvancmentId;
    }

    public void setTreeAdvancmentId(Long treeAdvancmentId) {
        this.treeAdvancmentId = treeAdvancmentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CompetitionDTO getCompetition() {
        return this.competition;
    }

    public void setCompetition(CompetitionDTO competition) {
        this.competition = competition;
    }

    public Set<TreeAdvancmentItemDTO> getTreeAdvancmentItems() {
        return this.treeAdvancmentItems;
    }

    public void setTreeAdvancmentItems(Set<TreeAdvancmentItemDTO> treeAdvancmentItems) {
        for (TreeAdvancmentItemDTO treeAdvancmentItemDTO : treeAdvancmentItems) {
            treeAdvancmentItemDTO.setTreeAvancment(this);
        }
        this.treeAdvancmentItems = treeAdvancmentItems;
    }

    public TreeAdvancment.Status getStatus() {
        return this.status;
    }

    public void setStatus(TreeAdvancment.Status status) {
        this.status = status;
    }

    public String toString() {
        return "TreeAdvancmentDTO [treeAdvancmentId=" + this.treeAdvancmentId + ", name=" + this.name + ", status=" + this.status + "]";
    }
}

