/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.server.dl.dao.TreeAdvancmentDAO;
import si.nevensrok.jtekma.server.management.TreeAdvancmentManager;

public class TreeAdvancmentManagerImpl
implements TreeAdvancmentManager {
    private static final Logger log = LoggerFactory.getLogger(TreeAdvancmentManagerImpl.class);
    private TreeAdvancmentDAO treeAdvancmentDAO;

    public void setTreeAdvancmentDAO(TreeAdvancmentDAO treeAdvancmentDAO) {
        this.treeAdvancmentDAO = treeAdvancmentDAO;
    }

    @Transactional(value="jtekmaTransactionManager")
    public TreeAdvancment createTreeAvancment(TreeAdvancment treeAdvancment) {
        if (log.isDebugEnabled()) {
            log.debug("Creating tree advancment {}", (Object)treeAdvancment);
        }
        return (TreeAdvancment)this.treeAdvancmentDAO.create((Pojo)treeAdvancment);
    }

    @Transactional(value="jtekmaTransactionManager")
    public TreeAdvancment updateTreeAvancment(TreeAdvancment treeAdvancment) {
        if (log.isDebugEnabled()) {
            log.debug("Updating tree advancment {}", (Object)treeAdvancment);
        }
        return (TreeAdvancment)this.treeAdvancmentDAO.update((Pojo)treeAdvancment);
    }

    @Transactional(value="jtekmaTransactionManager")
    public TreeAdvancment getById(Long treeAdvancmentId) {
        return (TreeAdvancment)this.treeAdvancmentDAO.getById((Object)treeAdvancmentId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public PageDataResult<TreeAdvancment> find(DataFilter dataFilter) {
        return this.treeAdvancmentDAO.find(dataFilter, false);
    }

    @Transactional(value="jtekmaTransactionManager")
    public PageDataResult<TreeAdvancment> find(Competition competition, DataFilter dataFilter) {
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("competition", FieldFilter.Comparator.EQUAL, (Object)competition.getId()));
        rootFilter.addFilter(dataFilter.getFilter());
        ((SimpleDataFilter)dataFilter).setFilter((Filter)rootFilter);
        return this.treeAdvancmentDAO.find(dataFilter, false);
    }

    @Transactional(value="jtekmaTransactionManager")
    public TreeAdvancment getForCategory(TreeCategory treeCategory) {
        return this.treeAdvancmentDAO.getForCategory(treeCategory);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<TreeAdvancment> getActiveTreeAdvancmentsForCompetitions(Competition competition) {
        return this.treeAdvancmentDAO.getActiveTreeAdvancmentsForCompetitions(competition);
    }

    @Transactional(value="jtekmaTransactionManager")
    public TreeAdvancment getActiveTreeAdvancmentByName(String name) {
        return this.treeAdvancmentDAO.getActiveTreeAdvancmentByName(name);
    }
}

