/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.club.ClubCompetitorCount;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.server.dl.dao.ClubDAO;
import si.nevensrok.jtekma.server.management.ClubManager;
import si.nevensrok.jtekma.server.management.CompetitorManager;

public class ClubManagerImpl
implements ClubManager {
    private static final Logger log = LoggerFactory.getLogger(ClubManagerImpl.class);
    private ClubDAO clubDAO;
    private CompetitorManager competitorManager;

    public void setClubDAO(ClubDAO clubDAO) {
        this.clubDAO = clubDAO;
    }

    public void setCompetitorManager(CompetitorManager competitorManager) {
        this.competitorManager = competitorManager;
    }

    @Transactional(value="jtekmaTransactionManager")
    public Club createClub(Club club) {
        if (log.isDebugEnabled()) {
            log.debug("Creating club {}", (Object)club);
        }
        return (Club)this.clubDAO.create((Pojo)club);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Club> createClubs(List<Club> clubs) {
        if (log.isDebugEnabled()) {
            log.debug("Creating clubs {}", clubs);
        }
        return this.clubDAO.createList(clubs);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Club updateClub(Club club) {
        if (log.isDebugEnabled()) {
            log.debug("Updating club {}", (Object)club);
        }
        return (Club)this.clubDAO.update((Pojo)club);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void deleteClub(Club club) {
        if (log.isDebugEnabled()) {
            log.debug("Deleting club {}", (Object)club);
        }
        for (Competitor competitor : this.competitorManager.getCompetitorsForClub(club)) {
            this.competitorManager.deleteCompetitor(competitor);
        }
        club = (Club)this.clubDAO.getById((Object)club.getClubId());
        club.setStatus(Club.Status.DELETED);
        this.clubDAO.update((Pojo)club);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Club getById(Long clubId) {
        return (Club)this.clubDAO.getById((Object)clubId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Club getByIdForCompetition(Competition competition, Long clubId) {
        return this.clubDAO.getByIdForCompetition(competition, clubId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public PageDataResult<Club> find(Competition competition, DataFilter dataFilter) {
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("competition", FieldFilter.Comparator.EQUAL, (Object)competition.getId()));
        rootFilter.addFilter(dataFilter.getFilter());
        ((SimpleDataFilter)dataFilter).setFilter((Filter)rootFilter);
        return this.clubDAO.find(dataFilter, false);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void deleteEmptyClubs(Competition competition) {
        List<Club> clubs = this.getActiveClubForCompetition(competition);
        Map<Club, ClubCompetitorCount> competitorCount = this.getClubCompetitorCount(new HashSet<Club>(clubs));
        for (Map.Entry<Club, ClubCompetitorCount> entry : competitorCount.entrySet()) {
            if (entry.getValue().getCompetitorsCount() != 0) continue;
            this.deleteClub(entry.getKey());
        }
    }

    @Transactional(value="jtekmaTransactionManager")
    public Club getClubForCompetitor(Competitor competitor) {
        return this.clubDAO.getClubForCompetitor(competitor);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Club getActiveClubByName(Competition competition, String name) {
        return this.clubDAO.getActiveClubByName(competition, name);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Club, ClubCompetitorCount> getClubCompetitorCount(Set<Club> clubs) {
        return this.clubDAO.getClubCompetitorCount(clubs);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Club> getActiveClubForCompetition(Competition competition) {
        Club example = new Club();
        example.setStatus(Club.Status.ACTIVE);
        example.setCompetition(competition);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFetchCount(false);
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        PageDataResult resultPage = this.clubDAO.find((DataFilter)dataFilter);
        return resultPage.getData();
    }
}

