/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.fileuploader;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.jtekma.server.fileuploader.FileUploader;

public class SftpFileUploader
implements FileUploader {
    private static final Logger log = LoggerFactory.getLogger(SftpFileUploader.class);

    @Override
    public boolean uploadFile(String hostname, int port, String username, final String password, String path, String fileName, byte[] fileContent, boolean overrideExisting) {
        Session session = null;
        ChannelSftp channel = null;
        try {
            JSch jsch = new JSch();
            session = jsch.getSession(username, hostname, port);
            session.setUserInfo(new UserInfo(){
                private boolean passwordSent = false;

                public void showMessage(String message) {
                }

                public boolean promptYesNo(String message) {
                    return true;
                }

                public boolean promptPassword(String message) {
                    if (this.passwordSent) {
                        return false;
                    }
                    this.passwordSent = true;
                    return true;
                }

                public boolean promptPassphrase(String message) {
                    return true;
                }

                public String getPassword() {
                    return password;
                }

                public String getPassphrase() {
                    return null;
                }
            });
            session.connect(10000);
            channel = (ChannelSftp)session.openChannel("sftp");
            channel.connect();
            if (!path.isEmpty()) {
                channel.cd(path);
            }
            ByteArrayInputStream buffer = new ByteArrayInputStream(fileContent);
            channel.put((InputStream)buffer, fileName, 0);
            channel.disconnect();
            session.disconnect();
            return true;
        }
        catch (Exception e) {
            try {
                channel.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                session.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.error("Error uploading file to SFTP server", (Throwable)e);
            return false;
        }
    }
}

