/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dataimport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import si.nevensrok.common.dataexport.FileWriter;
import si.nevensrok.common.dataimport.FileContent;
import si.nevensrok.common.dataimport.FileLine;
import si.nevensrok.common.dataimport.FileReader;
import si.nevensrok.jtekma.common.category.CategoryGroup;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.dataimport.ImportUtil;
import si.nevensrok.jtekma.server.dataimport.ImporterUtil;
import si.nevensrok.jtekma.server.management.CategoryGroupManager;

public class CategoryGroupImporter {
    private static final int bufferSize = 65536;
    private CategoryGroupManager categoryGroupManager;

    public void setCategoryGroupManager(CategoryGroupManager categoryGroupManager) {
        this.categoryGroupManager = categoryGroupManager;
    }

    public List<CategoryGroup> parseCategoryGroups(FileType fileType, byte[] fileData) throws Exception {
        LinkedList<CategoryGroup> categoryGroups = new LinkedList<CategoryGroup>();
        FileReader fileReader = ImporterUtil.getFileReader(fileType);
        FileContent fileContent = fileReader.readFile((InputStream)new ByteArrayInputStream(fileData));
        int categoryGroupNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Ime skupine", "Ime", "Skupina", "Naziv", "Group name", "Name"});
        if (categoryGroupNameIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoCategoryGroupName);
        }
        for (FileLine fileLine : fileContent.getLines()) {
            String name = ImportUtil.formatName(fileLine.getData(categoryGroupNameIndex));
            if (name == null || name.isEmpty()) continue;
            CategoryGroup categoryGroup = new CategoryGroup();
            categoryGroup.setName(name);
            categoryGroups.add(categoryGroup);
        }
        return categoryGroups;
    }

    public void importCategoryGroups(Competition competition, List<CategoryGroup> categoryGroups) throws Exception {
        for (CategoryGroup categoryGroup : categoryGroups) {
            categoryGroup.setCompetition(competition);
            if (this.categoryGroupManager.getCategoryGroupByName(competition, categoryGroup.getName()) != null) continue;
            this.categoryGroupManager.createCategoryGroup(categoryGroup);
        }
    }

    public byte[] exportCategoryGroups(FileType fileType, List<CategoryGroup> categoryGroups, String[] header) throws Exception {
        FileWriter fileWriter = ImporterUtil.getFileWriter(fileType);
        String[][] fileContent = new String[categoryGroups.size() + 1][];
        fileContent[0] = header;
        int i = 1;
        for (CategoryGroup categoryGroup : categoryGroups) {
            fileContent[i] = new String[]{categoryGroup.getName()};
            ++i;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        fileWriter.writeFile((OutputStream)buffer, fileContent);
        return buffer.toByteArray();
    }
}

