/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.settings;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.xml.datatype.DatatypeFactory;
import si.nevensrok.common.settings.Section;
import si.nevensrok.common.settings.Settings;
import si.nevensrok.common.settings.schema.BooleanValueType;
import si.nevensrok.common.settings.schema.BytesValueType;
import si.nevensrok.common.settings.schema.DateValueType;
import si.nevensrok.common.settings.schema.DecimalValueType;
import si.nevensrok.common.settings.schema.NumberValueType;
import si.nevensrok.common.settings.schema.SectionListType;
import si.nevensrok.common.settings.schema.SectionType;
import si.nevensrok.common.settings.schema.StringValueType;
import si.nevensrok.common.settings.schema.ValueListType;
import si.nevensrok.common.settings.schema.ValueType;

public class SectionTransformer {
    private static DatatypeFactory datatypeFactory;

    public static SectionType toSectionType(Section section) {
        SectionType sectionType = new SectionType();
        sectionType.setName(section.getName());
        sectionType.setValues(new ValueListType());
        for (Map.Entry<String, Object> entry : section.getCopyOfValues().entrySet()) {
            GregorianCalendar calendar;
            ValueType valueType = null;
            Object value = entry.getValue();
            if (value instanceof String) {
                valueType = new StringValueType();
                valueType.setValue((String)value);
            } else if (value instanceof Integer) {
                valueType = new NumberValueType();
                ((NumberValueType)valueType).setValue(((Integer)value).longValue());
            } else if (value instanceof Long) {
                valueType = new NumberValueType();
                ((NumberValueType)valueType).setValue((Long)value);
            } else if (value instanceof Float) {
                valueType = new DecimalValueType();
                ((DecimalValueType)valueType).setValue(((Float)value).doubleValue());
            } else if (value instanceof Double) {
                valueType = new DecimalValueType();
                ((DecimalValueType)valueType).setValue((Double)value);
            } else if (value instanceof Date) {
                valueType = new DateValueType();
                calendar = new GregorianCalendar();
                calendar.setTime((Date)value);
                ((DateValueType)valueType).setValue(datatypeFactory.newXMLGregorianCalendar(calendar));
            } else if (value instanceof Calendar) {
                valueType = new DateValueType();
                calendar = new GregorianCalendar();
                calendar.setTimeInMillis(((Calendar)value).getTimeInMillis());
                ((DateValueType)valueType).setValue(datatypeFactory.newXMLGregorianCalendar(calendar));
            } else if (value instanceof Boolean) {
                valueType = new BooleanValueType();
                ((BooleanValueType)valueType).setValue((Boolean)value);
            } else if (value instanceof byte[]) {
                valueType = new BytesValueType();
                ((BytesValueType)valueType).setValue((byte[])value);
            }
            valueType.setName(entry.getKey());
            sectionType.getValues().getValue().add(valueType);
        }
        sectionType.setSubSections(new SectionListType());
        for (Map.Entry<String, Object> entry : section.getCopyOfSections().entrySet()) {
            SectionType subSectionType = SectionTransformer.toSectionType((Section)entry.getValue());
            sectionType.getSubSections().getSection().add(subSectionType);
        }
        return sectionType;
    }

    public static Section toSection(Settings settings, SectionType sectionType) {
        Section section = new Section(sectionType.getName(), settings);
        for (ValueType valueType : sectionType.getValues().getValue()) {
            if (valueType instanceof StringValueType) {
                section.setValue(valueType.getName(), ((StringValueType)valueType).getValue());
                continue;
            }
            if (valueType instanceof NumberValueType) {
                section.setValue(valueType.getName(), ((NumberValueType)valueType).getValue());
                continue;
            }
            if (valueType instanceof DecimalValueType) {
                section.setValue(valueType.getName(), ((DecimalValueType)valueType).getValue());
                continue;
            }
            if (valueType instanceof DateValueType) {
                section.setValue(valueType.getName(), ((DateValueType)valueType).getValue().toGregorianCalendar().getTime());
                continue;
            }
            if (valueType instanceof BooleanValueType) {
                section.setValue(valueType.getName(), ((BooleanValueType)valueType).isValue());
                continue;
            }
            if (!(valueType instanceof BytesValueType)) continue;
            section.setValue(valueType.getName(), ((BytesValueType)valueType).getValue());
        }
        for (SectionType subSectionType : sectionType.getSubSections().getSection()) {
            Section subSection = SectionTransformer.toSection(settings, subSectionType);
            section.addSection(subSection);
        }
        return section;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

