-- no limit cycle sequence
create sequence RequestIdSeq minvalue 1 start with 1 increment by 1 cache 10;

-- limit and cycle sequence
create sequence RequestIdSeq2 minvalue 1 start with 1 maxvalue 9999999999 increment by 1 cache 10 cycle;


-- create table
CREATE TABLE Requests
(
	RequestId NUMBER(38) NOT NULL,
	MethodId VARCHAR2(3000) NOT NULL,
	BeanName VARCHAR2(2000),
	RequestDate TIMESTAMP NOT NULL,
	ThreadName VARCHAR2(4000) NOT NULL,
	Duration NUMBER(8) NOT NULL,
	WithoutError NUMBER(1) NOT NULL,
	ErrorData CLOB,
	MachineIp4 VARCHAR2(15),
	MachineIp6 VARCHAR2(45),
	MachineHostname VARCHAR2(1024),
	MachineName VARCHAR2(100),
	ProcessName VARCHAR2(1024),
	PRIMARY KEY (RequestId)
);


CREATE TABLE RequestDatas
(
	RequestId NUMBER(38) NOT NULL,
	ParameterName VARCHAR2(4000) NOT NULL,
	ParameterValue CLOB,
	ParameterClass VARCHAR2(4000)
);


CREATE TABLE ResponseDatas
(
	RequestId NUMBER(38) NOT NULL,
	ParameterName VARCHAR2(4000) NOT NULL,
	ParameterValue CLOB,
	ParameterClass VARCHAR2(4000)
);

ALTER TABLE ResponseDatas
	ADD CONSTRAINT FK_ResData_Requests
	FOREIGN KEY (RequestId)
	REFERENCES Requests (RequestId);


ALTER TABLE RequestDatas
	ADD CONSTRAINT FK_ReqData_Requests
	FOREIGN KEY (RequestId)
	REFERENCES Requests (RequestId);


create index Requests_SearchIndex1 on Requests (RequestDate,MethodId,BeanName,WithoutError);

