/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.velocity;

import java.io.InputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.springframework.core.io.ClassPathResource;

public class ClasspathResourceLoader
extends ResourceLoader {
    private String resourcePath = "/";

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        if (!this.resourcePath.endsWith("/")) {
            this.resourcePath = this.resourcePath + "/";
        }
    }

    public ClasspathResourceLoader() {
        this.setModificationCheckInterval(0L);
    }

    public void init(ExtendedProperties configuration) {
    }

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        InputStream inputStream = null;
        try {
            inputStream = source.startsWith("/") ? new ClassPathResource(source).getInputStream() : new ClassPathResource(this.getResourcePath() + source).getInputStream();
        }
        catch (Exception e) {
            throw new ResourceNotFoundException("Error while loading resource " + source, (Throwable)e);
        }
        return inputStream;
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

