/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.streams;

import java.io.IOException;
import java.io.InputStream;

public class ThrottledInputStream
extends InputStream {
    private static final long WINDOW_DURATION = 1000L;
    private InputStream inputStream;
    private long bytesPerSecond;
    private long lastWindowStartedAt = 0L;
    private long bytesReadInCurrentWindow = 0L;

    public ThrottledInputStream(InputStream inputStream, long bytesPerSecond) {
        if (bytesPerSecond < 1L) {
            throw new IllegalArgumentException("Bytes per second must be value greater than 0");
        }
        this.inputStream = inputStream;
        this.bytesPerSecond = bytesPerSecond;
    }

    public long getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public void setBytesPerSecond(long bytesPerSecond) {
        this.bytesPerSecond = bytesPerSecond;
    }

    @Override
    public synchronized int read() throws IOException {
        long currentTime = System.currentTimeMillis();
        long currentWindowLeftTime = 1000L - currentTime + this.lastWindowStartedAt;
        if (currentWindowLeftTime > 0L) {
            if (this.bytesReadInCurrentWindow >= this.bytesPerSecond) {
                try {
                    Thread.sleep(currentWindowLeftTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.lastWindowStartedAt = currentTime;
                this.bytesReadInCurrentWindow = 0L;
            }
        } else {
            this.lastWindowStartedAt = currentTime;
            this.bytesReadInCurrentWindow = 0L;
        }
        ++this.bytesReadInCurrentWindow;
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int n = this.read();
            if (n < 0) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            b[off + i] = (byte)n;
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

